/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include <QMainWindow>
#include <QCloseEvent>

#include "DummyProjCreation.h"
#include "DespotForm.h"
#include <map>
#include <vector>
//#include "InstantiateTemplate.h"
//#include "Instantiation.h"
#include "ProjectWorkspace.h"

class QTabWidget;

namespace DESpot
{
	class MainForm;
	class EventPoolForm;
	class ProjectWorkspace;
	class DesProject;
	class Des;
	class CtrlStdAlgo;
   	class MultiCtrlAlgo;
	class OutputUiPart;
	class ProjIntegrityAlgo;
	class UpdateProgressInterface;
	class TimedCtrl;
	//class InstantiateTemplate;
	class Instantiation;

	class ProjectEditor:	public QMainWindow, public DespotForm
	{
		Q_OBJECT

		public:
			ProjectEditor(MainForm* pMainForm, FormType formType);
			ProjectEditor(DesProject* project, MainForm* pMainForm, FormType formType);
			virtual ~ProjectEditor(void);
//add by bini		
		//public: typedef std::pair <Des*,InstantiateTemplate*> InstInfoMap;
			//typedef std::vector <std::pair<Des*,InstantiateTemplate*> > InstInfoMap_Vector;
			//typedef InstInfoMap::iterator InstInfoItr;
			//typedef InstInfoMap::const_iterator InstInfoCItr;
		

			//add by bini		
		signals:
			void onChangedTemplateInstantiate(bool isInstantiation);
			void setInstMode();

		public:

			DesProject* project();			
			virtual QString getDocName();
			virtual QString getDocFileName(); 

		//Menu/Toolbar Handlers_______________________________
		protected slots:
			virtual void onSaveProject();
			virtual void onSaveProjectAs();
			virtual void onDisplayEventPool();
			virtual void onProjectSetName();
			virtual void onPrintProject();
			virtual void onCloseProject();

			virtual void onAddDes();
			virtual void onEditDes();
			virtual void onRemoveDes();
//add by bini
			virtual void onInstantiateTemplate();
			virtual void onDeleteInstantiation(bool askConfirm = true);
			virtual void onRegenerateInstantiation();
			virtual void onEditInst();

			void onCheckProjectIntegrity(ProjIntegrityAlgo& integAlgo);
			virtual void onCheckProjectIntegrity();
			virtual void onCleanProject();
			virtual void onCheckProject();
			virtual void onRunMeetTool();
			virtual void onRunMultiCtrlTool();
			//Added by Amal for TDES
			virtual void onRunTimedCtrlTool();
			//
			virtual void onRunSyncProductTool();	
			virtual void onRunNonBlockingTool();
			virtual void onRunCtrlTool();
			virtual void onRunSynthesisTool();
			virtual void onRunSimTool();
			// Added by zain for counter example
			virtual void onRunCounterExampleTool();	
			//virtual void onRunErrorStateTool();

			//#ifdef __ENABLE_BDD__
				//Removed By Adam. no longer used in flat only hisc (moved to HierProjectEditor.h)
				virtual void onRunBddMeetTool();
				//virtual void onRunBddMultiCtrlTool();
				virtual void onRunBddSyncProductTool();	
				//virtual void onRunBddNonBlockingTool();
				virtual void onRunBddSynthesisTool();
			//#endif

			// Added by David for Distributed Tools
			virtual void onRunConfigDist();

			virtual void onChangedCurrentDes(Des* pCrtDes, Des* pOldCrtDes);
//add by bini
			virtual void onChangedCurrentInst(Instantiation* pCrtInst,Instantiation* pOldCrtInst);

		protected:
			virtual bool eventFilter(QObject* target, QEvent* event);						
			virtual void closeEvent(QCloseEvent *event);

		//Implementation methods_____________________________
		protected:
			void setupConnections();
			void updateWindowTitle();
			bool saveProjectDes();
			bool attemptSaveProject();
			bool attemptSaveProjectAs();

			OutputUiPart& output();

			UpdateProgressInterface* progressInterface();

		//Implementation data________________________________
		protected:
			DesProject* m_pProject;
			ProjectWorkspace* m_pWorkspace;
			EventPoolForm* m_pEventPoolForm;

			//The current component in the project
			Des* m_pCrtDes;
			Instantiation* m_pCrtInst;



	};

} //end of namespace DESpot
