/*	Author:		Amal Alsuwaidan
	Supervisor: 	Dr. Ryan Leduc
	

	Project submitted to the Department of Computing and Software of McMaster University
	in partial fulfilment of the requirements for the degree of M.A.Sc in Software Engineering
	2012 - 2016
*/
#pragma once
#include <iostream>
#include "BDDResetFTAlgo.h"
#include "Des.h"
#include "DesProject.h"
#include "FlatDummyProject.h"
#include "FlatProjIntegrityAlgo.h"
#include "BddSdMain.h"


namespace DESpot
{
BDDResetFTAlgo::BDDResetFTAlgo(const DesProject& currentProject, QList<QString>& faultSet ,int M , QMultiMap<int, QString>& faultSets, QMultiMap<int, QString>& resetSets) : ResetFTAlgo(currentProject, faultSet, M , faultSets, resetSets), m_BDDResetFaultsControllable(false)
{
}
//____________________________________________________________________________________________________________________________________	
BDDResetFTAlgo::~BDDResetFTAlgo()
{
}
//____________________________________________________________________________________________________________________________________
BDDSD::SD_CtrlChkInfo BDDResetFTAlgo::runBDDFTCtrlAlgo()
{
	DefaultFTAlgo::createDummyFlatProject();
	if (! m_faultSet.isEmpty())
	{
		DefaultFTAlgo::constructGF();
		DefaultFTAlgo::addGF();
	}
	ResetFTAlgo::constructGTFi();
	return BDDResetFTAlgo::verifyBDDFTCtrl();
}
//____________________________________________________________________________________________________________________________________
BDDSD::SD_CtrlChkInfo BDDResetFTAlgo::verifyBDDFTCtrl()
{ 
	FlatProjIntegrityAlgo integAlgo;
	if (m_flatDummyProject->checkIntegrity(integAlgo))
	{
		int tmp;
		BDDSD::SD_CtrlChkInfo  checkInfo("Project passes Untimed Controllability Check");
      		tmp = BddSdCheckCtrl((DesProject&) *m_flatDummyProject, checkInfo);

     		if (checkInfo.m_chkPassed)
			m_BDDResetFaultsControllable = true;
		else
			m_BDDResetFaultsControllable = false;

		return checkInfo;
	}
	else
	{throw EX("Project Integrity test has failed");}

}
//____________________________________________________________________________________________________________________________________
bool BDDResetFTAlgo::isBDDResetFaultsControllable() const
{return m_BDDResetFaultsControllable;}
}


