/*	Author:		Amal Alsuwaidan
	Supervisor: 	Dr. Ryan Leduc
	

	Project submitted to the Department of Computing and Software of McMaster University
	in partial fulfilment of the requirements for the degree of M.A.Sc in Software Engineering
	2012 - 2015
*/

#pragma once
//#include <iostream>
#include "DefaultFTAlgoTimed.h"
#include "TimedCtrl.h"
#include "FlatProjIntegrityAlgo.h"

namespace DESpot

{
DefaultFTAlgoTimed::DefaultFTAlgoTimed(const DesProject& currentProject, QList<QString>& faultSet): 
DefaultFTAlgo(currentProject,faultSet), m_isTimedDFTControllable(false)
{
	
}
//____________________________________________________________________________________________________________________________________	
DefaultFTAlgoTimed::~DefaultFTAlgoTimed()
{
}
//____________________________________________________________________________________________________________________________________
bool DefaultFTAlgoTimed::runAlgo()
{

	// check that excluded fault set is valid
	if (! (m_currentProject.isExcldEvntsValid()) )  {
	   throw EX("Excluded fault set not checked. Please run excluded fault set dialog.");
	} 

	if (! m_faultSet.isEmpty())	
	{
		DefaultFTAlgo::createDummyFlatProject();
		DefaultFTAlgo::constructGFTimed();
		DefaultFTAlgo::addGF();
		return DefaultFTAlgoTimed::verifyFTCtrl();
	}
	else
	{throw EX("There are no excluded fault events. Please run the standard timed controllability algorithm.");}

	return false;

}
//____________________________________________________________________________________________________________________________________
bool DefaultFTAlgoTimed::verifyFTCtrl()
{ 
	FlatProjIntegrityAlgo integAlgo;
	if (m_flatDummyProject->checkIntegrity(integAlgo))
	{
		TimedCtrl tCtrlAlgo(m_flatDummyProject->createDesIterator(ePlantDes),m_flatDummyProject->createDesIterator(eSupervisorDes));
		m_isTimedDFTControllable = m_flatDummyProject->checkTimedControllable(tCtrlAlgo);
		return m_isTimedDFTControllable;
	}
	else
	{
		throw EX("Project Integrity test has failed");
	}

	return m_isTimedDFTControllable;
}
//____________________________________________________________________________________________________________________________________
bool DefaultFTAlgoTimed::isTimedDFTControllable() const
{
	return m_isTimedDFTControllable;
}
//____________________________________________________________________________________________________________________________________
}


