/*	Author: Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#include "DesAlgo.h"

namespace DESpot
{

wchar_t DesAlgo::s_buffer[10000];

DesAlgo::DesAlgo(UpdateProgressInterface* progress, const std::wstring& desc) :
        m_progress(progress),m_runIncremental(false),  m_description(desc)
{
		isfirsterror=true;
		IsFirstErrorSubSystem=true;
		isFirstErrorAlgo=true;		
}

//_________________________________________________________________________________________________

DesAlgo::DesAlgo(const std::wstring& desc) :m_progress(null), m_runIncremental(false),  m_description(desc)
{
	
		isfirsterror=true;
		IsFirstErrorSubSystem=true;
		isFirstErrorAlgo=true;
}

//_________________________________________________________________________________________________

DesAlgo::~DesAlgo(void)
{
		if(!this->CE_tuplemap.empty())
			CE_tuplemap.clear();
}

//_________________________________________________________________________________________________

void DesAlgo::startAlgo()
{
	if (m_progress)
	{
		m_progress->startProgress();
	}
}

//_________________________________________________________________________________________________

void DesAlgo::updateProgress()
{
	if (m_progress)
	{
		m_progress->updateProgress();
	}
}

//_________________________________________________________________________________________________

void DesAlgo::finish()
{
	if (m_progress)
	{
		m_progress->finishProgress();
	}
}

//_________________________________________________________________________________________________

std::wstring DesAlgo::errorMessage(const std::wstring& format, const std::wstring& arg1)
{
        #ifdef MINGW_GCC
            swprintf(s_buffer, format.c_str(), arg1.c_str());
        #else
            swprintf(s_buffer, sizeof(s_buffer)/sizeof(wchar_t), format.c_str(), arg1.c_str());
        #endif
	return s_buffer;
}

//_________________________________________________________________________________________________

std::wstring DesAlgo::errorMessage(const std::wstring& format, const std::wstring& arg1, const std::wstring& arg2)
{
        #ifdef MINGW_GCC
            swprintf(s_buffer, format.c_str(), arg1.c_str(), arg2.c_str());
        #else
            swprintf(s_buffer, sizeof(s_buffer)/sizeof(wchar_t), format.c_str(), arg1.c_str(), arg2.c_str());
        #endif

	return s_buffer;
}

//_________________________________________________________________________________________________

std::wstring DesAlgo::errorMessage(const std::wstring& format, const std::wstring& arg1, const std::wstring& arg2, 
						  const std::wstring& arg3)
{
        #ifdef MINGW_GCC
            swprintf(s_buffer, format.c_str(), arg1.c_str(), arg2.c_str(), arg3.c_str());
        #else
            swprintf(s_buffer, sizeof(s_buffer)/sizeof(wchar_t), format.c_str(), arg1.c_str(), arg2.c_str(), arg3.c_str());
        #endif
	return s_buffer;
}

//_________________________________________________________________________________________________

std::wstring DesAlgo::errorMessage(const std::wstring& format, const std::wstring& arg1, const std::wstring& arg2, 
						  const std::wstring& arg3, const std::wstring& arg4)
{
        #ifdef MINGW_GCC
            swprintf(s_buffer, format.c_str(), arg1.c_str(), arg2.c_str(), arg3.c_str(), arg4.c_str());
        #else
            swprintf(s_buffer, sizeof(s_buffer)/sizeof(wchar_t), format.c_str(), arg1.c_str(), arg2.c_str(), arg3.c_str(), arg4.c_str());
        #endif

	return s_buffer;
}

//_________________________________________________________________________________________________

std::wstring DesAlgo::errorMessage(const std::wstring& format, const std::wstring& arg1, const std::wstring& arg2, 
						  const std::wstring& arg3, const std::wstring& arg4, const std::wstring& arg5)
{
        #ifdef MINGW_GCC
            swprintf(s_buffer, format.c_str(), arg1.c_str(), arg2.c_str(), arg3.c_str(), arg4.c_str(), arg5.c_str());
        #else
            swprintf(s_buffer, sizeof(s_buffer)/sizeof(wchar_t), format.c_str(), arg1.c_str(), arg2.c_str(), arg3.c_str(), arg4.c_str(), arg5.c_str());
        #endif
	return s_buffer;
}

//_________________________________________________________________________________________________

std::wstring DesAlgo::errorMessage(const std::wstring& format, const std::wstring& arg1, const std::wstring& arg2, 
						  const std::wstring& arg3, const std::wstring& arg4, const std::wstring& arg5, const std::wstring& arg6)
{
        #ifdef MINGW_GCC
            swprintf(s_buffer, format.c_str(), arg1.c_str(), arg2.c_str(), arg3.c_str(), arg4.c_str(), arg5.c_str(), arg6.c_str());
        #else
            swprintf(s_buffer, sizeof(s_buffer)/sizeof(wchar_t), format.c_str(), arg1.c_str(), arg2.c_str(), arg3.c_str(), arg4.c_str(), arg5.c_str(), arg6.c_str());
        #endif
	return s_buffer;
}

//_________________________________________________________________________________________________

std::wstring DesAlgo::errorMessage(const std::wstring& format, const std::wstring& arg1, const std::wstring& arg2, 
						           const std::wstring& arg3, const std::wstring& arg4, const std::wstring& arg5, 
								   const std::wstring& arg6, const std::wstring& arg7)
{
        #ifdef MINGW_GCC
            swprintf(s_buffer, format.c_str(), arg1.c_str(), arg2.c_str(), arg3.c_str(), arg4.c_str(), arg5.c_str(), arg6.c_str(), arg7.c_str());
        #else
            swprintf(s_buffer, sizeof(s_buffer)/sizeof(wchar_t), format.c_str(), arg1.c_str(), arg2.c_str(), arg3.c_str(), arg4.c_str(), arg5.c_str(), arg6.c_str(), arg7.c_str());
        #endif
	return s_buffer;
}
//_________________________________________________________________________________________________

bool DesAlgo::runEx(UpdateProgressInterface* progress)
{
	m_progress = progress;
	return runAlgo();
}

//_________________________________________________________________________________________________

void DesAlgo::provideProgress(UpdateProgressInterface* progress)
{
	m_progress = progress;
}

//_________________________________________________________________________________________________

const std::wstring& DesAlgo::getDescription() const
{
	return m_description;
}

//_________________________________________________________________________________________________

//returns the error list. Algorithms may override this method to be provide the error list
//as it is requested as opposed to while the algorithm is running
const DesAlgo::ErrorList& DesAlgo::getErrorList()
{
	return m_errorList;
}

//_________________________________________________________________________________________________

//returns the number of errors encountered
int DesAlgo::getErrorCount() const
{
	return m_errorList.size();
}
//_________________________________________________________________________________________________

//returns the number of warnings issued by the algorithm
int DesAlgo::getWarningCount() const
{
	return m_warningList.size();
}

//_________________________________________________________________________________________________

//returns the list of warnings issued by the algorithm
const DesAlgo::WarningList& DesAlgo::getWarningList()
{
	return m_warningList;
}


//_________________________________________________________________________________________________

void DesAlgo::addError(const std::wstring& error)
{
	m_errorList.push_back(error);
}

//_________________________________________________________________________________________________

void DesAlgo::addError(const ErrorList& errorList)
{
	m_errorList.insert(m_errorList.end(), errorList.begin(), errorList.end());
}

//_________________________________________________________________________________________________

void DesAlgo::addWarning(const std::wstring& warn)
{
	m_warningList.push_back(warn);
}


//_________________________________________________________________________________________________

void DesAlgo::addWarning(const WarningList& warnList)
{
	m_warningList.insert(m_warningList.end(), warnList.begin(), warnList.end());
}


//=================================================================================================

void DesAlgo::setIFailureType(IConstSubAlgos in_type)
{
	FailureType=in_type;
}
//=================================================================================================

} //namespace DESpot

