/*	Author:		Amal Alsuwaidan
	Supervisor: 	Dr. Ryan Leduc
	

	Project submitted to the Department of Computing and Software of McMaster University
	in partial fulfilment of the requirements for the degree of M.A.Sc in Software Engineering
	2012 - 2015
*/

#pragma once
#include "FlatDummyProject.h"

namespace DESpot

{	
FlatDummyProject::~FlatDummyProject()
{
}
//____________________________________________________________________________________________________________________________________

FlatDummyProject::FlatDummyProject(const DesProject& in_project):m_TempProject(in_project)
{			
	std::wstring name(L"DummyProj");
	DummyProjPtr = new DesFlatProject(name);
	// Set the trace file
	DummyProjPtr->setFileName(in_project.getFileName());

	int i=0;

	// Add project plants
	DesProject::DesIteratorPtr plantDesIt = m_TempProject.createDesIterator(ePlantDes);
	for(plantDesIt->first(); plantDesIt->notDone(); plantDesIt->next(),i++)
	{
		DummyProjPtr->addPlantDes(&clone(plantDesIt->currentItem()));
	}		

	//Add project supervisors 
	DesFlatProject::DesIteratorPtr supDesIt = m_TempProject.createDesIterator(eSupervisorDes);
	for(supDesIt->first(); supDesIt->notDone(); supDesIt->next(),i++)
	{
		DummyProjPtr->addSupDes(&clone(supDesIt->currentItem()));
	}		 
}
//____________________________________________________________________________________________________________________________________
Des& FlatDummyProject::clone(Des& existing_des)
{
	std::wstring desName= existing_des.getName();
	Des* newDes = new Des(desName, eRegularDes);
	DesSerializer loader(*newDes, newDes);
	loader.load_and_clone_des(existing_des);
	return *newDes;
}
//____________________________________________________________________________________________________________________________________
DesFlatProject* FlatDummyProject::GetDummyProject()
{
	return (DesFlatProject*)DummyProjPtr;
}

}


