/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#include <QMenu>
#include <QMenuBar>
#include <QToolBar>
#include <QIcon>
#include <QStatusBar>
#include <qevent.h>
#include <QHeaderView>
#include <QButtonGroup>

#include "FlatProjectWorkspace.h"
#include "CommonDefinitions.h"
#include "FlatProjectEditor.h"
#include "FlatProjStructureUiPart.h"
#include "FlatProjSummaryUiPart.h"
#include "DesViewUiPart.h"
#include "DesFlatProject.h"
#include "OutputUiPart.h"

namespace DESpot
{

FlatProjectWorkspace::FlatProjectWorkspace(FlatProjectEditor* pFlatProjectEditor, DesFlatProject* pProject) : 
	ProjectWorkspace(pFlatProjectEditor, pProject)
{
	//configure the form to use the FlatProjectEditor.ui
	setupUi(pFlatProjectEditor);

	//call the base class to set the title of the window given the fact that this is flat project
	//the base class will compose the full title and set it
	setProjectEditorTitle(STR_FLAT_PROJ_EDITOR, pProject->getName());

	//create the UI Parts of a flat project
	createUiParts(pProject);

	//setup menu, toolbar and status bar	
	createActions();
	setupMenu();
	setupToolBar();
	setupStatusBar();

	//setup event filters for child controls
	setupEventFilters();

	//set the spliter position
	positionSplitters();

	//setup connections between widgets
	setupConnections();

	//TODO: check if we can remove them for good
	m_projDetailsTabWidg->setCurrentIndex(0);
	m_projDetailsTabWidg->removeTab(2);
	m_projDetailsTabWidg->removeTab(1);

	pFlatProjectEditor->resize(630, 520);
}

//_________________________________________________________________________________________________

FlatProjectWorkspace::~FlatProjectWorkspace(void)
{
}

//_________________________________________________________________________________________________

void FlatProjectWorkspace::createUiParts(DesFlatProject* pProject)
{
	m_pProjStructUiPart = new FlatProjStructureUiPart(this, pProject);
	
	m_pSummaryUiPart = new FlatProjSummaryUiPart(this, pProject);
	
	m_pDesViewUiPart = new DesViewUiPart(this, pProject);
	
	m_pOutputUiPart	= new OutputUiPart(this, pProject);
	m_pOutputUiPart->setOwnerTabWidget(m_projDetailsTabWidg);

}

//_________________________________________________________________________________________________

//Added by Adam for BDDExport
void FlatProjectWorkspace::createActions()
{
	ProjectWorkspace::createActions();

//==================================================================================================================================================
		// Added by Amal for Timed DES
		m_runTimedCtrlToolAct = new QAction(tr("&TDES Controllability") , this);
		m_runTimedCtrlToolAct->setToolTip(tr("TDES controllability"));
		m_runTimedCtrlToolAct->setStatusTip(tr("Verifies if the timed flat project is controllable"));
		connect(m_runTimedCtrlToolAct, SIGNAL(triggered()), projectEditor(), SLOT(onRunTimedCtrlTool()));
//___________________________________________________________________________________________________________________________________________________
		// Added by Amal for FT Ctrl
		m_runFTCtrlToolAct1 = new QAction(tr("&Fault-Tolerant Controllability") , this);
		m_runFTCtrlToolAct1->setToolTip(tr("Fault-Tolerant Controllability"));
		m_runFTCtrlToolAct1->setStatusTip(tr("Verifies if flat project is FT controllable"));
		connect(m_runFTCtrlToolAct1, SIGNAL(triggered()), flatProjectEditor(), SLOT(onRunDFTCtrlTool()));

		m_runFTCtrlToolAct2 = new QAction(tr("&N-Fault-Tolerant Controllability"), this);
		m_runFTCtrlToolAct2->setToolTip(tr("N-Fault-Tolerant Controllability"));
		m_runFTCtrlToolAct2->setStatusTip(tr("Verifies if flat project is N-FT controllable"));
		connect(m_runFTCtrlToolAct2, SIGNAL(triggered()), flatProjectEditor(), SLOT(onRunNFFTCtrlTool()));

		m_runFTCtrlToolAct3 = new QAction(tr("&Non-repeatable N-Fault-Tolerant Controllability"), this);
		m_runFTCtrlToolAct3->setToolTip(tr("Non-repeatable N-Fault-Tolerant controllability"));
		m_runFTCtrlToolAct3->setStatusTip(tr("Verifies if flat project is NR-FT controllable"));
		connect(m_runFTCtrlToolAct3, SIGNAL(triggered()), flatProjectEditor(), SLOT(onRunNonRepFTCtrlTool()));

		m_runFTCtrlToolAct4 = new QAction(tr("&Resettable Fault-Tolerant Controllability"), this);
		m_runFTCtrlToolAct4->setToolTip(tr("Resettable Fault-Tolerant controllability"));
		m_runFTCtrlToolAct4->setStatusTip(tr("Verifies if flat project is RFT controllable"));
		connect(m_runFTCtrlToolAct4, SIGNAL(triggered()), flatProjectEditor(), SLOT(onRunResettableFTCtrlTool()));
//___________________________________________________________________________________________________________________________________________________
		// Added by Amal for Timed FT Ctrl
		m_runTimedFTCtrlToolAct1 = new QAction( tr("&Fault-Tolerant Controllability"), this);
		m_runTimedFTCtrlToolAct1->setToolTip(tr("&Fault-Tolerant Controllability"));
		m_runTimedFTCtrlToolAct1->setStatusTip(tr("Verifies if the timed flat project is FT controllable"));
		connect(m_runTimedFTCtrlToolAct1, SIGNAL(triggered()), flatProjectEditor(), SLOT(onRunTimedDFTCtrlTool()));

		m_runTimedFTCtrlToolAct2 = new QAction(tr("&N-Fault-Tolerant Controllability"), this);
		m_runTimedFTCtrlToolAct2->setToolTip(tr("&N-Fault-Tolerant Controllability"));
		m_runTimedFTCtrlToolAct2->setStatusTip(tr("Verifies if the timed flat project is N-FT controllable"));
		connect(m_runTimedFTCtrlToolAct2, SIGNAL(triggered()), flatProjectEditor(), SLOT(onRunTimedNFFTCtrlTool()));

		m_runTimedFTCtrlToolAct3 = new QAction(tr("&Non-repeatable N-Fault-Tolerant Controllability"), this);
		m_runTimedFTCtrlToolAct3->setToolTip(tr("&Non-repeatable N-Fault-Tolerant Controllability"));
		m_runTimedFTCtrlToolAct3->setStatusTip(tr("Verifies if the timed flat project is NR-FT controllable"));
		connect(m_runTimedFTCtrlToolAct3, SIGNAL(triggered()), flatProjectEditor(), SLOT(onRunTimedNonRepFTCtrlTool()));

		m_runTimedFTCtrlToolAct4 = new QAction(tr("&Resettable Fault-Tolerant Controllability"), this);
		m_runTimedFTCtrlToolAct4->setToolTip(tr("&Resettable Fault-Tolerant Controllability"));
		m_runTimedFTCtrlToolAct4->setStatusTip(tr("Verifies if the timed flat project is RFT controllable"));
		connect(m_runTimedFTCtrlToolAct4, SIGNAL(triggered()), flatProjectEditor(), SLOT(onRunTimedResettableFTCtrlTool()));
//___________________________________________________________________________________________________________________________________________________
		// Added by Amal for FT Nonblocking
		m_runFTNonBlockToolAct1 = new QAction(tr("&Fault-Tolerant NonBlocking") , this);
		m_runFTNonBlockToolAct1->setToolTip(tr("Fault-Tolerant NonBlocking"));
		m_runFTNonBlockToolAct1->setStatusTip(tr("Verifies if flat project is FT NonBlocking"));
		connect(m_runFTNonBlockToolAct1, SIGNAL(triggered()), flatProjectEditor(), SLOT(onRunDFTNonBlockTool()));

		m_runFTNonBlockToolAct2 = new QAction(tr("&N-Fault-Tolerant NonBlocking"), this);
		m_runFTNonBlockToolAct2->setToolTip(tr("N-Fault-Tolerant NonBlocking"));
		m_runFTNonBlockToolAct2->setStatusTip(tr("Verifies if flat project is N-FT NonBlocking"));
		connect(m_runFTNonBlockToolAct2, SIGNAL(triggered()), flatProjectEditor(), SLOT(onRunNFFTNonBlockTool()));

		m_runFTNonBlockToolAct3 = new QAction(tr("&Non-repeatable N-Fault-Tolerant NonBlocking"), this);
		m_runFTNonBlockToolAct3->setToolTip(tr("Non-repeatable N-Fault-Tolerant NonBlocking"));
		m_runFTNonBlockToolAct3->setStatusTip(tr("Verifies if flat project is NR-FT NonBlocking"));
		connect(m_runFTNonBlockToolAct3, SIGNAL(triggered()), flatProjectEditor(), SLOT(onRunNonRepFTNonBlockTool()));

		m_runFTNonBlockToolAct4 = new QAction(tr("&Resettable Fault-Tolerant NonBlocking"), this);
		m_runFTNonBlockToolAct4->setToolTip(tr("Resettable Fault-Tolerant NonBlocking"));
		m_runFTNonBlockToolAct4->setStatusTip(tr("Verifies if flat project is RFT NonBlocking"));
		connect(m_runFTNonBlockToolAct4, SIGNAL(triggered()), flatProjectEditor(), SLOT(onRunResettableFTNonBlockTool()));
//___________________________________________________________________________________________________________________________________________________
		//Added by Amal FTDES toolbar buttons
		m_saveFaultsToolAct = new QAction(QIcon(":/resources/SigmaDeltaF.png"), tr("&Select Excluded Faults"), this);
		m_saveFaultsToolAct->setToolTip(tr("Choose excluded fault events"));
		m_saveFaultsToolAct->setStatusTip(tr("Specify the excluded fault events for the fault-tolerant system"));
		m_saveFaultsToolAct->setEnabled(true);
		connect(m_saveFaultsToolAct, SIGNAL(triggered()), flatProjectEditor() , SLOT(onRunSaveFaultsTool()));

		m_saveFaultsReseatableToolAct = new QAction(QIcon(":/resources/SigmaFi.png"), tr("&Select Fault Sets"), this);
		m_saveFaultsReseatableToolAct->setToolTip(tr("Choose fault event sets"));
		m_saveFaultsReseatableToolAct->setStatusTip(tr("Specify fault event sets for the fault-tolerant system"));
		m_saveFaultsReseatableToolAct->setEnabled(true);
		connect(m_saveFaultsReseatableToolAct, SIGNAL(triggered()), projectEditor(), SLOT(onRunSaveFaultsSetsTool()));
//==================================================================================================================================================

	//Added by Adam for BDDExport
	m_exportToBDDsdAct = new QAction(tr("Export to BDDsd"), this);
	m_exportToBDDsdAct->setToolTip(tr("Export to BDDsd"));
	m_exportToBDDsdAct->setStatusTip(tr("Export to BDDsd"));
	connect(m_exportToBDDsdAct, SIGNAL(triggered()), flatProjectEditor(), SLOT(onExportToBDDsd()));

#ifdef __ENABLE_BDD__
	//Added by Adam for Flat project bdd tools

	m_runBddCheckAllToolAct = new QAction(QIcon(":/resources/checkProject.png"), tr("&Check All"), this);
	m_runBddCheckAllToolAct->setToolTip(tr("Check All (BDD)"));
//	m_runBddCheckAllToolAct->setStatusTip(tr("using BDD algorithms"));
	connect(m_runBddCheckAllToolAct, SIGNAL(triggered()), flatProjectEditor(), SLOT(onRunBddCheckAllTool()));

	m_runBddNonblockingToolAct = new QAction(QIcon(":/resources/checkNonblocking.png"), tr("&Nonblocking"), this);
	m_runBddNonblockingToolAct->setToolTip(tr("Check Nonblocking (BDD)"));
	m_runBddNonblockingToolAct->setStatusTip(tr("Verifies if the current DES is nonblocking using BDD algorithms"));
	connect(m_runBddNonblockingToolAct, SIGNAL(triggered()), flatProjectEditor(), SLOT(onRunBddNonblockingTool()));

	m_runBddTDESControllabilityToolAct = new QAction(/*QIcon(":/resources/TDESControllability.png"),*/ tr("&TDES Controllability"), this);
	m_runBddTDESControllabilityToolAct->setToolTip(tr("Check TDES Controllability"));
	m_runBddTDESControllabilityToolAct->setStatusTip(tr("Verifies if the current DES is TDES controllable using BDD algorithms"));
	connect(m_runBddTDESControllabilityToolAct, SIGNAL(triggered()), flatProjectEditor(), SLOT(onRunBddTDESControllabilityTool()));

	m_runBddControllabilityToolAct = new QAction(/*QIcon(":/resources/Controllability.png"),*/ tr("&Controllability"), this);
	m_runBddControllabilityToolAct->setToolTip(tr("Check Untimed Controllability"));
	m_runBddControllabilityToolAct->setStatusTip(tr("Verifies if the current DES is untimed controllable using BDD algorithms"));
	connect(m_runBddControllabilityToolAct, SIGNAL(triggered()), flatProjectEditor(), SLOT(onRunBddControllabilityTool()));

	m_runBddNBControllabilityToolAct = new
	QAction(/*QIcon(":/resources/NBControllability.png"),*/ tr("&Nonblocking and Controllability"), this);
	m_runBddNBControllabilityToolAct->setToolTip(tr("Check Nonblocking and Untimed Controllability"));
	m_runBddNBControllabilityToolAct->setStatusTip(tr("Verifies if the current DES is nonblocking and untimed controllable using BDD algorithms"));
	connect(m_runBddNBControllabilityToolAct, SIGNAL(triggered()), flatProjectEditor(), SLOT(onRunBddNBControllabilityTool()));

	m_runBddSDControllabilityToolAct = new QAction(/*QIcon(":/resources/SDControllability.png"),*/ tr("&SD Controllability"), this);
	m_runBddSDControllabilityToolAct->setToolTip(tr("Check SD Controllability"));
	m_runBddSDControllabilityToolAct->setStatusTip(tr("Verifies if the current DES is SD controllable using BDD algorithms"));
	connect(m_runBddSDControllabilityToolAct, SIGNAL(triggered()), flatProjectEditor(), SLOT(onRunBddSDControllabilityTool()));

	m_runBddProperTimebehaviorToolAct = new QAction(/*QIcon(":/resources/ProperTimebehavior.png"),*/ tr("&Proper Time behavior"), this);
	m_runBddProperTimebehaviorToolAct->setToolTip(tr("Proper Time behavior"));
//	m_runBddProperTimebehaviorToolAct->setStatusTip(tr("Verifies if the current subsystem is level-wise nonblocking using BDD algorithms"));
	connect(m_runBddProperTimebehaviorToolAct, SIGNAL(triggered()), flatProjectEditor(), SLOT(onRunBddProperTimebehaviorTool()));

	m_runBddSSingularProhibitableBehaviorToolAct = new QAction(/*QIcon(":/resources/SSingularProhibitableBehavior.png"),*/ tr("&S-Singular Prohibitable Behavior"), this);
	m_runBddSSingularProhibitableBehaviorToolAct->setToolTip(tr("Check S-Singular Prohibitable Behavior"));
//	m_runBddSSingularProhibitableBehaviorToolAct->setStatusTip(tr("Verifies if the project is level-wise controllable using BDD algorithms"));
	connect(m_runBddSSingularProhibitableBehaviorToolAct, SIGNAL(triggered()), flatProjectEditor(), SLOT(onRunBddSSingularProhibitableBehaviorTool()));

	m_runBddPlantCompletenessToolAct = new QAction(/*QIcon(":/resources/PlantCompleteness.png"),*/ tr("&Plant Completeness"), this);
	m_runBddPlantCompletenessToolAct->setToolTip(tr("Check PlantCompleteness"));
	m_runBddPlantCompletenessToolAct->setStatusTip(tr("Verifies the Plant Completeness using BDD algorithms"));
	connect(m_runBddPlantCompletenessToolAct, SIGNAL(triggered()), flatProjectEditor(), SLOT(onRunBddPlantCompletenessTool()));

	m_runBddALFToolAct = new QAction(/*QIcon(":/resources/ALF.png"),*/ tr("&ALF"), this);
//	m_runBddALFToolAct->setToolTip(tr("Runs level-wise sythesis for HISC project"));
//	m_runBddALFToolAct->setStatusTip(tr("Constructs supremal, controllable, nonblocking level-wise supervisors for project using BDD algorithms"));
	connect(m_runBddALFToolAct, SIGNAL(triggered()), flatProjectEditor(), SLOT(onRunBddALFTool()));

//Added by Amal for FT
	m_onRunBDDDFTCtrlAct = new QAction(tr("&Fault-Tolerant Controllability"), this);
	m_onRunBDDDFTCtrlAct->setToolTip(tr("Fault-Tolerant Controllability"));
	m_onRunBDDDFTCtrlAct->setStatusTip(tr("Verifies FT Controllability using BDD"));
	connect(m_onRunBDDDFTCtrlAct, SIGNAL(triggered()), flatProjectEditor(), SLOT(onRunBDDDFTCtrlTool()));

	m_onRunTimedBDDDFTCtrlAct = new QAction(tr("&Timed Fault-Tolerant Controllability"), this);
	m_onRunTimedBDDDFTCtrlAct->setToolTip(tr("Timed Fault-Tolerant Controllability"));
	m_onRunTimedBDDDFTCtrlAct->setStatusTip(tr("Verifies Timed FT Controllability using BDD"));
	connect(m_onRunTimedBDDDFTCtrlAct, SIGNAL(triggered()), flatProjectEditor(), SLOT(onRunTimedBDDDFTCtrlTool()));

	m_onRunBDDNFFTCtrlAct= new QAction(tr("&N-Fault-Tolerant Controllability"), this);
	m_onRunBDDNFFTCtrlAct->setToolTip(tr("N-Fault-Tolerant Controllability"));
	m_onRunBDDNFFTCtrlAct->setStatusTip(tr("Verifies N-FT Controllability using BDD"));
	connect(m_onRunBDDNFFTCtrlAct, SIGNAL(triggered()), flatProjectEditor(), SLOT(onRunBDDNFFTCtrlTool())); 

	m_onRunTimedBDDNFFTCtrlAct= new QAction(tr("&Timed N-Fault-Tolerant Controllability"), this);
	m_onRunTimedBDDNFFTCtrlAct->setToolTip(tr("Timed N-Fault-Tolerant Controllability"));
	m_onRunTimedBDDNFFTCtrlAct->setStatusTip(tr("Verifies Timed N-FT Controllability using BDD"));
	connect(m_onRunTimedBDDNFFTCtrlAct, SIGNAL(triggered()), flatProjectEditor(), SLOT(onRunTimedBDDNFFTCtrlTool())); 

	m_onRunBDDNonRepFTCtrlAct = new QAction(tr("&Non-repeatable N-Fault-Tolerant Controllability"), this);
	m_onRunBDDNonRepFTCtrlAct->setToolTip(tr("Non-repeatable N-Fault-Tolerant Controllability"));
	m_onRunBDDNonRepFTCtrlAct->setStatusTip(tr("Verifies NR-FT controllability using BDD"));
	connect(m_onRunBDDNonRepFTCtrlAct, SIGNAL(triggered()), flatProjectEditor(), SLOT(onRunBDDNonRepFTCtrlTool()));

	m_onRunTimedBDDNonRepFTCtrlAct = new QAction(tr("&Timed Non-repeatable N-Fault-Tolerant Controllability"), this);
	m_onRunTimedBDDNonRepFTCtrlAct->setToolTip(tr("Timed Non-repeatable N-Fault-Tolerant Controllability"));
	m_onRunTimedBDDNonRepFTCtrlAct->setStatusTip(tr("Verifies Timed NR-FT controllability using BDD"));
	connect(m_onRunTimedBDDNonRepFTCtrlAct, SIGNAL(triggered()), flatProjectEditor(), SLOT(onRunTimedBDDNonRepFTCtrlTool()));

	m_onRunBDDResettableFTCtrlAct = new QAction(tr("&Resettable Fault-Tolerant Controllability"), this);
	m_onRunBDDResettableFTCtrlAct->setToolTip(tr("Resettable Fault-Tolerant Controllability"));
	m_onRunBDDResettableFTCtrlAct->setStatusTip(tr("Verifies RFT Controllability using BDD"));
	connect(m_onRunBDDResettableFTCtrlAct, SIGNAL(triggered()), flatProjectEditor(), SLOT(onRunBDDResettableFTCtrlTool()));

	m_onRunTimedBDDResettableFTCtrlAct = new QAction(tr("&Timed Resettable Fault-Tolerant Controllability"), this);
	m_onRunTimedBDDResettableFTCtrlAct->setToolTip(tr("Timed Resettable Fault-Tolerant Controllability"));
	m_onRunTimedBDDResettableFTCtrlAct->setStatusTip(tr("Verifies Timed RFT Controllability using BDD"));
	connect(m_onRunTimedBDDResettableFTCtrlAct, SIGNAL(triggered()), flatProjectEditor(), SLOT(onRunTimedBDDResettableFTCtrlTool()));

	m_onRunBDDDFTNonBlockAct = new QAction(tr("&Fault-Tolerant Nonblocking"), this);
	m_onRunBDDDFTNonBlockAct->setToolTip(tr("Fault-Tolerant Nonblocking"));
	m_onRunBDDDFTNonBlockAct->setStatusTip(tr("Verifies FT nonblocking using BDD"));
	connect(m_onRunBDDDFTNonBlockAct, SIGNAL(triggered()), flatProjectEditor(), SLOT(onRunBDDDFTNonBlockTool()));

	m_onRunBDDNFFTNonBlockAct = new QAction(tr("&N-Fault-Tolerant Nonblocking"), this);
	m_onRunBDDNFFTNonBlockAct->setToolTip(tr("N-Fault-Tolerant Nonblocking"));
	m_onRunBDDNFFTNonBlockAct->setStatusTip(tr("Verifies N-FT Nonblocking using BDD"));
	connect(m_onRunBDDNFFTNonBlockAct, SIGNAL(triggered()), flatProjectEditor(), SLOT(onRunBDDNFFTNonBlockTool()));

	m_onRunBDDNonRepFTNonBlockAct = new QAction(tr("&Non-repeatable N-Fault-Tolerant Nonblocking"), this);
	m_onRunBDDNonRepFTNonBlockAct->setToolTip(tr("Non-repeatable N-Fault-Tolerant Nonblocking"));
	m_onRunBDDNonRepFTNonBlockAct ->setStatusTip(tr("Verifies NR-FT Nonblocking using BDD"));
	connect(m_onRunBDDNonRepFTNonBlockAct, SIGNAL(triggered()), flatProjectEditor(), SLOT(onRunBDDNonRepFTNonBlockTool()));


	m_onRunBDDResettableFTNonBlockAct = new QAction(tr("&Resettable Fault-Tolerant Nonblocking"), this);
	m_onRunBDDResettableFTNonBlockAct->setToolTip(tr("Resettable Fault-Tolerant Nonblocking"));
	m_onRunBDDResettableFTNonBlockAct->setStatusTip(tr("Verifies RFT Nonblocking using BDD"));
	connect(m_onRunBDDResettableFTNonBlockAct, SIGNAL(triggered()), flatProjectEditor(), SLOT(onRunBDDResettableFTNonBlockTool()));

#endif

	// Added by David for Distributed TOols
	m_runDistCheckAll = new QAction(QIcon(":/resources/checkProject.png"), tr("Check All"), this);	
	connect(m_runDistCheckAll, SIGNAL(triggered()), flatProjectEditor(), SLOT(onRunDistCheckAll()));
#ifndef __ENABLE_DIST__
	m_runDistCheckAll->setDisabled(true);
#endif
}

//_________________________________________________________________________________________________

//Added by Adam for BDDExport

void FlatProjectWorkspace::setupMenu()
{
	ProjectWorkspace::setupMenu();

	//Setup actions specific for Flat
	
	//Added by Adam for BDDExport
	m_projectMenu->insertAction(m_projectSetNameAct, m_exportToBDDsdAct);
	m_projectMenu->insertSeparator(m_projectSetNameAct);

        //  Added by RJL to add the fault event dialogs to the project menu
        m_projectMenu->insertAction(m_viewEventPoolAct, m_saveFaultsToolAct);
        m_projectMenu->insertAction(m_viewEventPoolAct,  
           m_saveFaultsReseatableToolAct);

	//Added by Amalfor Timed DES & FT Cont.
	m_toolsMenu->addSeparator();
	m_toolsMenu->addAction(m_runTimedCtrlToolAct);
	m_toolsMenu->addSeparator();
	m_FTCtrlMenu = m_toolsMenu->addMenu(tr("&Fault-Tolerant Controllability"));
	{
		//setup the FT Ctrl. menu
		m_FTCtrlMenu->addAction(m_runFTCtrlToolAct1);
		m_FTCtrlMenu->addAction(m_runFTCtrlToolAct2);
		m_FTCtrlMenu->addAction(m_runFTCtrlToolAct3);
		m_FTCtrlMenu->addAction(m_runFTCtrlToolAct4);
	}
	m_TimedFTCtrlMenu = m_toolsMenu->addMenu(tr("&Timed Fault-Tolerant Controllability"));
	{
		//setup the FT Ctrl. menu
		m_TimedFTCtrlMenu->addAction(m_runTimedFTCtrlToolAct1);
		m_TimedFTCtrlMenu->addAction(m_runTimedFTCtrlToolAct2);
		m_TimedFTCtrlMenu->addAction(m_runTimedFTCtrlToolAct3);
		m_TimedFTCtrlMenu->addAction(m_runTimedFTCtrlToolAct4);
	}
	m_toolsMenu->addSeparator();
	m_FTNonBlockMenu = m_toolsMenu->addMenu(tr("&Fault-Tolerant Nonblocking"));
	{
		m_FTNonBlockMenu->addAction(m_runFTNonBlockToolAct1);
		m_FTNonBlockMenu->addAction(m_runFTNonBlockToolAct2);
		m_FTNonBlockMenu->addAction(m_runFTNonBlockToolAct3);
		m_FTNonBlockMenu->addAction(m_runFTNonBlockToolAct4);
	}
	m_toolsMenu->addSeparator();
#ifdef __ENABLE_BDD__
	//addded by Adam for Flat project specifric BDD tools in the tool menu
	m_bddToolsMenu->insertAction(m_runBddMeetToolAct, m_runBddCheckAllToolAct);
	m_bddToolsMenu->insertAction(m_runBddMeetToolAct, m_runBddNonblockingToolAct);
	m_bddToolsMenu->insertAction(m_runBddMeetToolAct, m_runBddControllabilityToolAct);
	m_bddToolsMenu->insertAction(m_runBddMeetToolAct, m_runBddNBControllabilityToolAct);
	//Added by Amal for FT
	m_bddToolsMenu->addSeparator();
	m_BDDFTCtrlMenu = m_bddToolsMenu->addMenu(tr("&BDD Fault-Tolerant Controllability"));
	{
		m_BDDFTCtrlMenu->addAction(m_onRunBDDDFTCtrlAct);
		m_BDDFTCtrlMenu->addAction(m_onRunBDDNFFTCtrlAct);		
		m_BDDFTCtrlMenu->addAction(m_onRunBDDNonRepFTCtrlAct);		
		m_BDDFTCtrlMenu->addAction(m_onRunBDDResettableFTCtrlAct);				
	}
	m_TimedBDDFTCtrlMenu = m_bddToolsMenu->addMenu(tr("&BDD Timed Fault-Tolerant Controllability"));
	{
		m_TimedBDDFTCtrlMenu->addAction(m_onRunTimedBDDDFTCtrlAct);
		m_TimedBDDFTCtrlMenu->addAction
                   (m_onRunTimedBDDNFFTCtrlAct);		
		m_TimedBDDFTCtrlMenu->addAction
                   (m_onRunTimedBDDNonRepFTCtrlAct);		
		m_TimedBDDFTCtrlMenu->addAction(m_onRunTimedBDDResettableFTCtrlAct);
	}
	m_BDDFTNonBlockMenu = m_bddToolsMenu->addMenu(tr("&BDD Fault-Tolerant Nonblocking"));
	{
		m_BDDFTNonBlockMenu->addAction(m_onRunBDDDFTNonBlockAct);
		m_BDDFTNonBlockMenu->addAction(m_onRunBDDNFFTNonBlockAct);
		m_BDDFTNonBlockMenu->addAction(m_onRunBDDNonRepFTNonBlockAct);
		m_BDDFTNonBlockMenu->addAction(m_onRunBDDResettableFTNonBlockAct);		
	}
	m_bddToolsMenu->addSeparator();

	m_bddToolsMenu->insertAction(m_runBddMeetToolAct, m_runBddTDESControllabilityToolAct);
	m_bddToolsMenu->insertAction(m_runBddMeetToolAct, m_runBddSDControllabilityToolAct);
	m_bddToolsMenu->insertAction(m_runBddMeetToolAct, m_runBddProperTimebehaviorToolAct);
	m_bddToolsMenu->insertAction(m_runBddMeetToolAct, m_runBddSSingularProhibitableBehaviorToolAct);
	m_bddToolsMenu->insertAction(m_runBddMeetToolAct, m_runBddPlantCompletenessToolAct);
	m_bddToolsMenu->insertAction(m_runBddMeetToolAct, m_runBddALFToolAct);
	m_bddToolsMenu->insertSeparator(m_runBddMeetToolAct);
#endif

	// Added by David for Distributed Tools
	m_distToolsMenu->addAction(m_runDistCheckAll);
}

//_________________________________________________________________________________________________

void FlatProjectWorkspace::setupConnections()
{
	ProjectWorkspace::setupConnections();

	//TODO: setup connections between the onChangedCurrentDes signal from the project structure UI Part
	//and onChangedCurrentDes slot of the DES view UI part
}

//_________________________________________________________________________________________________
//Added by Amal for FT DES
void FlatProjectWorkspace::setupToolBar()
{
	ProjectWorkspace::setupToolBar();

	m_toolsToolBar->addSeparator();
	m_toolsToolBar->addAction(m_saveFaultsToolAct);
	m_toolsToolBar->addAction(m_saveFaultsReseatableToolAct);

}
//_________________________________________________________________________________________________
ProgressWidget* FlatProjectWorkspace::progressWidget()
{
	return m_progressWidget;
}

//_________________________________________________________________________________________________

FlatProjectEditor* FlatProjectWorkspace::flatProjectEditor()
{
	return dynamic_cast<FlatProjectEditor*>(projectEditor());
}

//_________________________________________________________________________________________________

void FlatProjectWorkspace::setupEventFilters()
{
	centralWidget->installEventFilter(this);
	m_projDetailsTabWidg->installEventFilter(this);
}

//_________________________________________________________________________________________________

bool FlatProjectWorkspace::eventFilter(QObject* target, QEvent* event)
{	
	if (target == centralWidget && event->type() == QEvent::Resize)
	{
		QResizeEvent* resizeEvent = dynamic_cast<QResizeEvent*>(event);
		m_mainSplitterWidg->resize(resizeEvent->size() - QSize(20, 22));
	}		
	else if (target == m_projDetailsTabWidg && event->type() == QEvent::Resize)
	{
		QResizeEvent* resizeEvent = dynamic_cast<QResizeEvent*>(event);
		
		const QSize layoutSize = resizeEvent->size() - QSize(18,50);		
		m_summaryPageLayout->resize(layoutSize);
		m_nonBlockPageLayout->resize(layoutSize);
		m_ctrlPageLayout->resize(layoutSize);		
		m_desDetailsLayoutWidg->resize(layoutSize);
		m_outputPageLayout->resize(layoutSize);
	}

	return ProjectWorkspace::eventFilter(target, event);
}

//_________________________________________________________________________________________________

//Arrange the position of all splitters to have the following arrangement:
//		- Project Structure area occupies ~30% of the space
//		- Des Details occupies the rest of ~70 of the space
void FlatProjectWorkspace::positionSplitters()
{
	//Calculate the 30/70 width sizes for the main splitter
	const float cProjectStructRatio = 3;
	QSize mainSplitterSize   = m_mainSplitterWidg->size();
        int   projStructAreaWidth = (int)(mainSplitterSize.width() / cProjectStructRatio);
	int   desDetailsAreaWidth = mainSplitterSize.width() - projStructAreaWidth; // the rest of the splitter;

	//arrange the main spliter to have the above sizes
	QList<int> mainSplitterSizeList;
	mainSplitterSizeList.push_back(projStructAreaWidth);
	mainSplitterSizeList.push_back(desDetailsAreaWidth);
	m_mainSplitterWidg->setSizes(mainSplitterSizeList);
}

} //end of namespace DESpot
