/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc

	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering,
	Computing and Software Department,
	McMaster University
	2003 - 2007
*/

#pragma once

#include "Workspace.h"
#include "ui_MainForm.h"
#include <QtXml/QDomDocument>
class QResizeEvent;

namespace DESpot
{

class MainForm;
class RecentDocListUIPart;
class OpenedWndUiPart;

class MainWorkspace : public Workspace, private Ui::MainFormUI
{
	Q_OBJECT

	public:
		MainWorkspace(MainForm* pMainForm, QDomDocument& configDoc);
		virtual ~MainWorkspace(void);

	public:
		RecentDocListUIPart* projListUiPart();
		RecentDocListUIPart* desListUiPart();
		OpenedWndUiPart* wndListUiPart();

		bool useGraphEditor();

	//Overridables__________________________________
	protected:
		virtual bool eventFilter(QObject* target, QEvent* event);

private:
		MainForm* mainForm();
		void createUiParts(QDomDocument& configDoc);
		void setupConnections();
		void createActions();
		void setupMenu();
		void setupToolBar();
		void setupStatusBar();

		void setupEventFilters();
		void positionSplitters();

	//Actions_______________________________________
	private:
	    //project actions
		QAction* m_newFlatProjectAct;
		QAction* m_newHierProjectAct;
		QAction* m_openProjectAct;
        QAction* m_newRegressionTestAct;
        QAction* m_openRegressionTestAct;

		//DES actions
		QAction* m_newDesAct;
		QAction* m_openDesAct;

		// Editor choice
		QAction *m_tabularEditorAct;
		QAction *m_graphEditorAct;

		//generation actions
		QAction* m_exitAppAct;

		//windows actions
		QAction* m_showSelWndAct;
		QAction* m_closeSelWndAct;
		
		//help actions
		QAction* m_openHelpFileAct;
		QAction* m_aboutDespotAct;

		#ifdef __ENABLE_NEXT_VERSION__
			//Workspace actions
			QAction* m_openWorkspaceAct;
			QAction* m_saveWorkspaceAct;
			std::vector<QAction*> m_openRecentWorkspaceActSet;
			static const int cRecentWorkspaceCount;

			QAction* m_cascadeSelWndAct;
			QAction* m_tileHorizSelWndAct;
			QAction* m_tileVertSelWndAct;
			QAction* m_cascadeAllWndAct;
			QAction* m_tileHorizAllWndAct;
			QAction* m_tileVertAllWndAct;

			
		#endif


	//Menus_________________________________________
	private:
		QMenu* m_startMenu;
		QMenu* m_desMenu;
		QMenu* m_newProjectMenu;
		QMenu* m_openWorkspaceMenu;
		QMenu* m_newDesMenu;
		QMenu* m_helpMenu;
		QMenu* m_windowsMenu;


	//Toolbars______________________________________
	private:
		QToolBar* m_startToolbar;

	//UI Parts
	private:
		RecentDocListUIPart* m_projListUiPart;
		RecentDocListUIPart* m_desListUiPart;
		OpenedWndUiPart*	 m_wndListUiPart;
};

} //end of namespace DESpot
