/*	Author:		Amal Alsuwaidan
	Supervisor: 	Dr. Ryan Leduc
	

	Project submitted to the Department of Computing and Software of McMaster University
	in partial fulfilment of the requirements for the degree of M.A.Sc in Software Engineering
	2012 - 2015	
*/

#pragma once
#include "DefaultFTAlgo.h"
#include <QList>
#include <QMultiMap>

namespace DESpot
{	
	class NonRepFTAlgo : public  DefaultFTAlgo
	{
	public:
		NonRepFTAlgo(const DesProject& currentProject, QList<QString>& faultSet ,int M , int N , QMultiMap<int, QString>& faultSets);
		~NonRepFTAlgo();
		bool runAlgo();
		void constructGNF();
		void addGNF();
		void constructGFi();
		void addGFi(Des* GFiDes);
		bool verifyFTCtrl();
		bool isnonRepFaultsControllable() const;

	protected:
		Des* GNFDes;
		int m_M;
		int m_N;
		QMultiMap<int, QString>& m_faultSets;
	private:
		bool m_isnonRepFaultsControllable;
	};
}
