/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include <QtXml/QDomElement>
#include <map>

#include "ui_MainForm.h"
#include "DespotTreeWidget.h"


namespace DESpot
{
	class DespotForm;

	class RecentDocListUIPart	: public QObject
	{
		Q_OBJECT
		
		public:
			enum DocType
			{
				eProjectDoc,
				eDesDoc
			};

		public:
			RecentDocListUIPart(DocType docType, Ui::MainFormUI* pUiContainer, QDomElement& recentDocConfig);
			~RecentDocListUIPart(void);

		public:
			void saveConfig(QDomDocument& configDoc);

		public:
			virtual bool eventFilter(QObject* target, QEvent* event);			

		public slots:
			void onDocumentFormOpened(DespotForm* docForm);
			void onDocumentFormClosed(DespotForm* docForm);
			
		signals:
			void onOpenDocument(const QString& fileName);

		//Implementation Methods________________________
		private:
			void initUi(Ui::MainFormUI* pUiContainer);
			void setupConnections();
			void initDocListWidget();			
			void loadDocList();
			bool findDoc(const QString& desLocation, QTreeWidgetItem*& out_item, int& out_index);
			bool checkFormType(DespotForm* docForm);
			void updateDocConfig(QMainWindow* closingWnd);
		
		private slots:
			void resizeDocListWidgHeaders(int width);
			void onOpenCrtDoc();
			void onRemoveCrtDoc();

		private:    
			DespotTreeWidget* m_docListWidg;
		    
			//The type of document in the Recently Used List (DES or Project)
			DocType m_docType;

			QString m_docTag;
			QString m_docHeader;

			QPushButton *m_openCrtDocBtn;
		    QPushButton *m_removeCrtDocBtn;

			QDomElement	  m_docListConfig;

			typedef std::map<DespotForm*, QTreeWidgetItem*> FormMap;
			typedef FormMap::iterator FormMapIt;
			FormMap m_openedFormsMap;

		//constants
		private:
			static const short cDocListWidgColumnCount;
			static const short cDocNameColumnIdx;
			static const short cDocFileColumnIdx;

			static const QString cProjectHeader;
			static const QString cDesHeader;
			static const QString cFileHeader;

			static const QString cDesTag;
			static const QString cProjectTag;
			static const QString cDocNameAttr;
			static const QString cDocLocAttr;

	};

} //end of namespace DESpot
