<?php
session_start();
require ('config.inc.php');
require ('security.inc.php');
require (LOGIC_DIR.'mySmarty.class.php'); 
require (LOGIC_DIR.'Admin.class.php');
require (LOGIC_DIR.'pThumb.class.php');
require (LOGIC_DIR.'functions.inc.php');
$smarty = new mySmarty;

//Global variables
$TPL_NAME = '';
//Sitewide variables
$smarty -> assign('userlevel',$_SESSION['userlevel']);	
$cmsModules = Admin::getModules(); 
$smarty -> assign('modules', $cmsModules);

$smarty->assign('rootURL',ROOT_URL);
$smarty->assign('postURL', $_SERVER['PHP_SELF']);
//FORM PROCESSING
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
	if (isset($_POST['action'])) {
		switch($_POST['action']) {
			case 'login': {
				if ($userdata = Admin::isValidUser($_POST['userName'],$_POST['password'])) {
					$_SESSION['userid'] = $userdata['id'];
					$_SESSION['userlevel'] = $userdata['rights'];
					header('Location: '. ROOT_URL.'admin/contentcontrol/');
				} else {
					$smarty -> assign('error','               ');
					$smarty -> display('admin/login.tpl');
				}
				break;
			}
			case 'modcontrol': {
				Admin::setModules($_POST['active']);
				header('Location: '.ROOT_URL.'admin/modcontrol/');
				break;
			}
			case 'modconfig': {
				if (isset($_POST['item'])) {
					$configs = Admin::getConfigs($_POST['item']);
					for ($i=0;$i<count($configs);$i++) {
						if (isset($_POST['configs'][$configs[$i]['id']]) || isset($_FILES['configs']['tmp_name'][$configs[$i]['id']])) {							
							if ($configs[$i]['type'] == 'i' || $configs[$i]['type'] == 't' || $configs[$i]['type'] == 'a' || $configs[$i]['type'] == 'r' || $configs[$i]['type'] == 's') {
								Admin::updateConfig($configs[$i]['id'],$_POST['configs'][$configs[$i]['id']]);
							} elseif ($configs[$i]['type'] == 'c') {
								$j = 0;
								foreach ($_POST['configs'][$configs[$i]['id']] as $key => $value) {
									$strvalues[$j++] = $key;
								}
								if (isset($strvalues)) {
									$strvalues = implode(':',$strvalues);
								}
								Admin::updateConfig($configs[$i]['id'],$strvalues);
							} elseif ($configs[$i]['type'] == 'f') {
								$img = badUploadFile($_FILES['configs']['tmp_name'][$configs[$i]['id']]);
								Admin::updateConfig($configs[$i]['id'],$img);
							}
						}
					}
				}
				header ('Location: '.ROOT_URL.'admin/modconfig/'.$_POST['item'].'/');
				break;
			}
			case 'adduser': {
				if (isset($_POST['active']))
					$active = 1;
				else
					$active = 0;
				Admin::addUser($_POST['userName'],$_POST['password'],$_POST['fullName'],$_POST['email'],$_POST['rights'],$active);
				header('Location: '.ROOT_URL.'admin/userconfig/');
				break;
			}
			case 'edituser': {
				if (isset($_POST['active']))
					$active = 1;
				else
					$active = 0;
				Admin::editUser($_POST['userid'],$_POST['userName'],$_POST['password'],$_POST['fullName'],$_POST['email'],$_POST['rights'],$active);
				header('Location: '.ROOT_URL.'admin/userconfig/');
				break;
			}
			case 'userconfig': {
				Admin::setActiveUsers($_POST['active']);
				header('Location: '.ROOT_URL.'admin/userconfig/');
				break;
			}
			case 'modules': {
				for ($i=0;$i<count($cmsModules);$i++) {
					if (!empty($cmsModules[$i]['adminfilename'])) {
						if ($cmsModules[$i]['id'] == $_POST['modid']) {
							$moduleName = $cmsModules[$i]['name'];
							$adminFilename = $cmsModules[$i]['adminfilename'];
							require (MODULES_DIR.$moduleName.'/'.$adminFilename);
							header('Location: '.ROOT_URL.'admin/modules/'.$_POST['modid']);						
							exit;
						} 
					}
				}	
				$smarty -> display ('admin/noModuleContent.tpl');			
				break;
			}
		}
	}
}
else if ($_SERVER['REQUEST_METHOD'] === 'GET') {
	switch ($_GET['action']) {		
		case 'siteconfig': {
			$smarty -> display('admin/siteConfig.tpl');
			break;
		}
		case 'modcontrol':  {
			$smarty -> display('admin/modControl.tpl');
			break;
		}
		case 'modconfig': {
			if (isset($_GET['modid'])) {
				$smarty -> assign('item',$_GET['modid']);
				$configs = Admin::getConfigs($_GET['modid']);
				$smarty -> assign('configs',$configs);
			}
			$smarty -> display('admin/modConfig.tpl');
			break;
		}
		case 'userconfig': {
			if (isset($_GET['add'])) {
				$smarty -> assign('action','adduser');
				$smarty -> display('admin/editUser.tpl');
			} elseif (isset($_GET['edit'])) {
				$smarty -> assign('action','edituser');
				$smarty -> assign('userid',$_GET['edit']);
				$users = Admin::getUser($_GET[edit]); 
				$smarty -> assign('users',$users);
				$smarty -> display('admin/editUser.tpl');
			} else {
				$users = Admin::getUserList();
				$smarty -> assign('action','adduser');
				$smarty -> assign('users',$users);
				$smarty -> display('admin/userConfig.tpl');
			}
			break;
		}
		case 'contentcontrol': {		
			$smarty -> display('admin/contentControl.tpl');
			break;
		}
		case 'modules': {
			if (isset($cmsModules) && count($cmsModules)>0)
			{
				for ($i=0;$i<count($cmsModules);$i++) {
					if ($cmsModules[$i]['id'] == $_GET['moduleid']) {
						if (!empty($cmsModules[$i]['adminfilename'])) {
							$moduleName = $cmsModules[$i]['name'];
							$adminFilename = $cmsModules[$i]['adminfilename'];
							require ('modules/'.$moduleName.'/'.$adminFilename);
							$smarty -> display ('modules/'.$TPL_NAME);
						} else {
							$smarty -> display ('admin/noModuleContent.tpl');
						}
					}
				}
			}
			break;		
		}
		case 'login': {
			$smarty -> display('admin/login.tpl');
			break;
		}
		case 'logout': {
			session_destroy();
			header('Location: '.ROOT_URL.'admin/login');
			break;
		}
		default: {
			$smarty -> display('admin/login.tpl');
			break;
		}
	}
}

?>
