<?php
$level = $_SESSION['level'];

require_once ('modORResources.class.php');
require_once (MODULES_DIR.'modORMessages'.DIRECTORY_SEPARATOR.'modORMessages.class.php');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
//here we proceed with POST requests
	if (isset($_POST['moduleid']) && $_POST['moduleid'] == 'orr') { //module id
		if (isset($_POST['action']) && $_POST['action'] == 'addln' && isset($_POST['language'])) //action id
		{
			//add language
			if ($level > 0) modORMessages::no_admin(); else {
				if (modORResources::add_language($_POST['language'])){
					$languages = modORResources::get_languages();
					$smarty -> assign('languages', $languages);
					$TPL_NAME = 'modules'.DIRECTORY_SEPARATOR.$MODULE_NAME.DIRECTORY_SEPARATOR.'languages.tpl';
				} else {
					modORMessages::msg('Language cannot be added.', true, 'orr/languages');
				}
			}

		}
		elseif (isset($_POST['action']) && $_POST['action'] == 'addkw' && isset($_POST['keyword'])){
		//add keyword
			if ($level > 1) modORMessages::no_admin(); else {
				if (modORResources::add_keyword($_POST['keyword'])){
					$keywords = modORResources::get_keywords();
					$smarty -> assign('keywords', $keywords);
					$TPL_NAME = 'modules'.DIRECTORY_SEPARATOR.$MODULE_NAME.DIRECTORY_SEPARATOR.'keywords.tpl';
				} else {
					modORMessages::msg('Keyword cannot be added.', true, 'orr/keywords');
				}
			}

		}
		elseif (isset($_POST['action']) && $_POST['action'] == 'submit'){
		//submit new resource
        
            // BJH - Save the posted values in case there's an issue, and clear on success
            $_SESSION['new_res'] = $_POST ;                        

			$botckey = substr($_SESSION['key'],0,5);
			if ($level > 2) modORMessages::no_rights(); 
			 elseif ($_POST['botcapt'] != $botckey){
				modORMessages::msg('Your code is invalid please check again.', true, 'orr/submit');
			} else {
				$id = modORResources::add_resource(1, time(), $_SESSION['user']);
				if ($id){
					modORResources::update_res_keywords($id, $_POST['keywords']);
					if ($_POST['type_id'] == 1) {
						//conference
						$r = modORResources::add_res_conference($id, $_POST['type_id'], time(), $_SESSION['user'], $_POST['title'], $_POST['author'], $_POST['year'], $_POST['summary'], $_POST['language_id'], $_POST['ol_summary'], $_POST['url'], $_POST['note'], $_POST['month'], $_POST['custom_keywords'], $_POST['con_name'], $_POST['con_place'], $_POST['con_pages'], 'Initial');
					}elseif ($_POST['type_id'] == 2) {
						//journal
						$r = modORResources::add_res_journal($id, $_POST['type_id'], time(), $_SESSION['user'], $_POST['title'], $_POST['author'], $_POST['year'], $_POST['summary'], $_POST['language_id'], $_POST['ol_summary'], $_POST['url'], $_POST['note'], $_POST['month'], $_POST['custom_keywords'], $_POST['jour_name'], $_POST['jour_vol_no'], $_POST['jour_pages'], $_POST['jour_issue'], $_POST['jour_month'], 'Initial');
					}elseif ($_POST['type_id'] == 3) {
						//book
						$r = modORResources::add_res_book($id, $_POST['type_id'], time(), $_SESSION['user'], $_POST['title'], $_POST['author'], $_POST['year'], $_POST['summary'], $_POST['language_id'], $_POST['ol_summary'], $_POST['url'], $_POST['note'], $_POST['month'], $_POST['custom_keywords'], $_POST['b_place'], $_POST['b_publisher'], $_POST['b_isbn'], 'Initial');
					}elseif ($_POST['type_id'] == 4) {
						//technical report
						$r = modORResources::add_res_tr($id, $_POST['type_id'], time(), $_SESSION['user'], $_POST['title'], $_POST['author'], $_POST['year'], $_POST['summary'], $_POST['language_id'], $_POST['ol_summary'], $_POST['url'], $_POST['note'], $_POST['month'], $_POST['custom_keywords'], $_POST['tr_type'], $_POST['tr_inst_name'], $_POST['tr_inst_addr'], $_POST['tr_report_no'], 'Initial');
					}elseif ($_POST['type_id'] == 5) {
						//thesis
						$r = modORResources::add_res_th($id, $_POST['type_id'], time(), $_SESSION['user'], $_POST['title'], $_POST['author'], $_POST['year'], $_POST['summary'], $_POST['language_id'], $_POST['ol_summary'], $_POST['url'], $_POST['note'], $_POST['month'], $_POST['custom_keywords'], $_POST['th_label'], $_POST['th_school_addr'], $_POST['th_department'], $_POST['tr_report_no'], 'Initial');
					} else $r = false;
					if ($r) {
                        modORMessages::msg('Resource submitted successfully.');
                        unset($_SESSION['new_res']);
                    }
				} else {
					modORMessages::msg('Resource cannot be added.', true, 'orr/keywords');
				}
			}
		} elseif (isset($_POST['action']) && $_POST['action'] == 'edit' && isset($_POST['res_id'])){
		//edit resource
			$botckey = substr($_SESSION['key'],0,5);
			
            // BJH - Save the submitted values in case of a problem
            $_SESSION['last_item_res'] = $_POST ;                          

			if ($level > 1) modORMessages::no_rights(); 
			elseif ($_POST['changes'] == '') {
				modORMessages::msg('You must complete all required fields.', true, 'orr/edit/'.$_POST['res_id']);
			} elseif ($_POST['botcapt'] != $botckey){
				modORMessages::msg('Your code is invalid please check again.', true, 'orr/edit/'.$_POST['res_id']);
			}
			else {
				modORResources::update_res_keywords($_POST['res_id'], $_POST['keywords']);
				$id = modORResources::edit_resource($_POST['res_id']);
				if ($id){
					if ($_POST['type_id'] == 1) {
						//conference
						$r = modORResources::add_res_conference($id, $_POST['type_id'], time(), $_SESSION['user'], $_POST['title'], $_POST['author'], $_POST['year'], $_POST['summary'], $_POST['language_id'], $_POST['ol_summary'], $_POST['url'], $_POST['note'], $_POST['month'], $_POST['custom_keywords'], $_POST['con_name'], $_POST['con_place'], $_POST['con_pages'], $_POST['changes']);
					}elseif ($_POST['type_id'] == 2) {
						//journal
						$r = modORResources::add_res_journal($id, $_POST['type_id'], time(), $_SESSION['user'], $_POST['title'], $_POST['author'], $_POST['year'], $_POST['summary'], $_POST['language_id'], $_POST['ol_summary'], $_POST['url'], $_POST['note'], $_POST['month'], $_POST['custom_keywords'], $_POST['jour_name'], $_POST['jour_vol_no'], $_POST['jour_pages'], $_POST['jour_issue'], $_POST['jour_month'], $_POST['changes']);
					}elseif ($_POST['type_id'] == 3) {
						//book
						$r = modORResources::add_res_book($id, $_POST['type_id'], time(), $_SESSION['user'], $_POST['title'], $_POST['author'], $_POST['year'], $_POST['summary'], $_POST['language_id'], $_POST['ol_summary'], $_POST['url'], $_POST['note'], $_POST['month'], $_POST['custom_keywords'], $_POST['b_place'], $_POST['b_publisher'], $_POST['b_isbn'], $_POST['changes']);
					}elseif ($_POST['type_id'] == 4) {
						//technical report
						$r = modORResources::add_res_tr($id, $_POST['type_id'], time(), $_SESSION['user'], $_POST['title'], $_POST['author'], $_POST['year'], $_POST['summary'], $_POST['language_id'], $_POST['ol_summary'], $_POST['url'], $_POST['note'], $_POST['month'], $_POST['custom_keywords'], $_POST['tr_type'], $_POST['tr_inst_name'], $_POST['tr_inst_addr'], $_POST['tr_report_no'], $_POST['changes']);
					}elseif ($_POST['type_id'] == 5) {
						//thesis
						$r = modORResources::add_res_th($id, $_POST['type_id'], time(), $_SESSION['user'], $_POST['title'], $_POST['author'], $_POST['year'], $_POST['summary'], $_POST['language_id'], $_POST['ol_summary'], $_POST['url'], $_POST['note'], $_POST['month'], $_POST['custom_keywords'], $_POST['th_label'], $_POST['th_school_addr'], $_POST['th_department'], $_POST['tr_report_no'], $_POST['changes']);
					} else $r = false;
					if ($r) {
                        modORMessages::msg('Resource changed successfully.');
                        unset($_SESSION['last_item_res']) ;
                    }
				} else {
					modORMessages::msg('Resource cannot be edited.', true, 'orr/keywords');
				}
			
			}
		}elseif (isset($_POST['action']) && $_POST['action'] == 'filter'){
			//user clicked on filter button in list resources page
			if ($level > 2) modORMessages::no_admin(); else {
				
				if ($_POST['sub_mail'])
				{
					$user_details = modORProfiles::get_profile_bymail($_POST['sub_mail']);
					$sub_id = $user_details['id'];
                    
                    if ($sub_id == null && $_POST['sub_mail'] != '')
                        $sub_id = "0" ;
				}
				if ($_POST['ver_mail'])
				{
					$user_details = modORProfiles::get_profile_bymail($_POST['ver_mail']);
					$ver_id = $user_details['id'];

                    if ($ver_id == null && $_POST['ver_mail'] != '')
                        $ver_id = "0" ;
				}
				if ($_POST['app_mail'])
				{
					$user_details = modORProfiles::get_profile_bymail($_POST['app_mail']);
					$app_id = $user_details['id'];
                    
                    if ($app_id == null && $_POST['app_mail'] != '')
                        $app_id = "0" ;
				}
				if ($_POST['mod_mail'])
				{
					$user_details = modORProfiles::get_profile_bymail($_POST['mod_mail']);
					$mod_id = $user_details['id'];
                    
                    if ($mod_id == null && $_POST['mod_mail'] != '')
                        $mod_id = "0" ;
				}
				
                if (strtotime($_POST['sub_date_from']) == -1 || strtotime($_POST['sub_date_from']) === FALSE) 
                    $_POST['sub_date_from'] = '' ;
                
                if (strtotime($_POST['sub_date_to']) == -1 || strtotime($_POST['sub_date_to']) === FALSE)
                    $_POST['sub_date_to'] = '' ;
                    
                if (strtotime($_POST['mod_date_from']) == -1 || strtotime($_POST['mod_date_from']) === FALSE)
                    $_POST['mod_date_from'] = '' ;
                    
                if (strtotime($_POST['mod_date_to']) == -1 || strtotime($_POST['mod_date_to']) === FALSE)
                    $_POST['mod_date_to'] = '' ;                
                
                $resources = modORResources::get_all_resources($_POST['status'], $_POST['sub_date_from'], $_POST['sub_date_to'], $_POST['mod_date_from'], $_POST['mod_date_to'], $sub_id, $ver_id, $app_id, $mod_id, 0, ITEMS_PER_PAGE, $rowcount) ;
                
                $_SESSION['filter_search'] = $_POST ;
                $_SESSION['filter_search']['sub_id'] = $sub_id ;
                $_SESSION['filter_search']['ver_id'] = $ver_id ;
                $_SESSION['filter_search']['app_id'] = $app_id ;
                $_SESSION['filter_search']['mod_id'] = $mod_id ;
                $_SESSION['filter_search']['status'] = $_POST['status'] ;
                
                $smarty->assign('src', $_SESSION['filter_search']) ;
                
                if ($rowcount<=ITEMS_PER_PAGE) {
                    // BJH - Unset the session variable for a filtered search
                    unset($_SESSION['filter_search']) ;
                } else {
                    $smarty->assign('next_id', 2) ;
                }

				$smarty->assign('status', $_POST['status']);

                $smarty->assign('resources', $resources);
				
				$TPL_NAME = 'modules'.DIRECTORY_SEPARATOR.$MODULE_NAME.DIRECTORY_SEPARATOR.'resources.tpl';
			}

		}elseif (isset($_POST['action']) && $_POST['action'] == 'massaction')
		{
			//admin action
			//some boxes are checked and admin clicked on button
			if ($level > 0) modORMessages::no_admin(); else {
				if ($_POST['submit'] == 'delete') //delete btn clicked
				{
					if (is_array($_POST['selected']) && count(is_array($_POST['selected']) > 0))
					foreach ($_POST['selected'] as $key)
						modORResources::delete_resource($key);
					modORMessages::msg('Resources are deleted', true, 'orr/list');	
				}elseif ($_POST['submit'] == 'change') //warn btn clicked
				{
					if (is_array($_POST['selected']) && count(is_array($_POST['selected']) > 0))
					foreach ($_POST['selected'] as $key)
						modORResources::set_res_status($key ,$_POST['status']);
					modORMessages::msg('Status set', true, 'orr/list');	
				}
			}
		}
	}
}

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
//proceed GET requests
	if (isset($_GET['moduleid']) && $_GET['moduleid'] == 'orr') { //module id

		if (isset($_GET['action']) && $_GET['action'] == 'submit') { //action
		//show submit resource page
			if ($level > 2) modORMessages::no_admin(); else {
				$smarty -> assign('languages', modORResources::get_languages());
                
                if (isset($_SESSION['new_res'])) {
                    $smarty->assign('res', $_SESSION['new_res']);
                    
                    modORResources::get_keywords_selected($_SESSION['new_res']['keywords'], $keywords, $okeywords) ;
                    
                    $smarty->assign('keywords', $keywords);
                    $smarty->assign('okeywords', $okeywords);
                    
                    unset($_SESSION['new_res']);
                } else {
                    $smarty -> assign('keywords', modORResources::get_keywords());
                }
                
				$TPL_NAME = 'modules'.DIRECTORY_SEPARATOR.$MODULE_NAME.DIRECTORY_SEPARATOR.'submitresource.tpl';
			}
		} elseif (isset($_GET['action']) && $_GET['action'] == 'languages') {
		//show languages page
			if ($level > 0) modORMessages::no_admin(); else {
				$languages = modORResources::get_languages();
				$smarty -> assign('languages', $languages);
				$TPL_NAME = 'modules'.DIRECTORY_SEPARATOR.$MODULE_NAME.DIRECTORY_SEPARATOR.'languages.tpl';
			}

		} elseif (isset($_GET['action']) && $_GET['action'] == 'delln' && isset($_GET['item'])) {
		//delete specified language
			if ($level > 0) modORMessages::no_admin(); else {
				modORResources::del_language($_GET['item']);
				$languages = modORResources::get_languages();
				$smarty -> assign('languages', $languages);
				$TPL_NAME = 'modules'.DIRECTORY_SEPARATOR.$MODULE_NAME.DIRECTORY_SEPARATOR.'languages.tpl';
			}
		} elseif (isset($_GET['action']) && $_GET['action'] == 'keywords') {
		//show keywords page
			if ($level > 1) modORMessages::no_admin(); else {
				$keywords = modORResources::get_keywords();
				$smarty -> assign('keywords', $keywords);
				$TPL_NAME = 'modules'.DIRECTORY_SEPARATOR.$MODULE_NAME.DIRECTORY_SEPARATOR.'keywords.tpl';
			}

		} elseif (isset($_GET['action']) && $_GET['action'] == 'delkw' && isset($_GET['item'])) {
		//delete specified keyword
			if ($level > 1) modORMessages::no_admin(); else {
				modORResources::del_keyword($_GET['item']);
				$keywords = modORResources::get_keywords();
				$smarty -> assign('keywords', $keywords);
				$TPL_NAME = 'modules'.DIRECTORY_SEPARATOR.$MODULE_NAME.DIRECTORY_SEPARATOR.'keywords.tpl';
			}
		} elseif (isset($_GET['action']) && $_GET['action'] == 'get' && isset($_GET['item'])) {
		//open resource for detail view
			//if ($level > 3) modORMessages::no_admin(); else {
				$resource = modORResources::get_resource($_GET['item']);
				if (!empty($resource['url']) && substr($resource['url'],0,4) != 'http')
					$resource['url'] = 'http://'.$resource['url'];
                    
                // BJH - Create line breaks in the resource summaries
                $resource['summary'] = nl2br($resource['summary']);
                $resource['ol_summary'] = nl2br($resource['ol_summary']);
                
				$smarty -> assign('res', $resource);
				
				//get names
				$user_profile = modORProfiles::get_profile($resource['submiter_id']);
				$smarty -> assign('submiter_name', $user_profile['mail']);
				$user_profile = modORProfiles::get_profile($resource['verifier_id']);
				$smarty -> assign('verifier_name', $user_profile['mail']);
				$user_profile = modORProfiles::get_profile($resource['approver_id']);
				$smarty -> assign('approver_name', $user_profile['mail']);
				$user_profile = modORProfiles::get_profile($resource['mod_id']);
				$smarty -> assign('modifier_name', $user_profile['mail']);
				
				$smarty -> assign('keywords', modORResources::get_res_full_keywords($_GET['item']));
				$smarty -> assign('lnname', modORResources::get_language_name($resource['language_id']));
				$TPL_NAME = 'modules'.DIRECTORY_SEPARATOR.$MODULE_NAME.DIRECTORY_SEPARATOR.'resource.tpl';
			//}
		} elseif (isset($_GET['action']) && $_GET['action'] == 'edit' && isset($_GET['item'])) {
		//open resource for editing
			if ($level > 1) modORMessages::no_admin(); else {
				$smarty -> assign('languages', modORResources::get_languages());
				$res = modORResources::get_resource($_GET['item']);

                if (isset($_SESSION['last_item_res']) && $_SESSION['last_item_res']['res_id'] == $_GET['item']) {
                    $_SESSION['last_item_res']['id'] = $_SESSION['last_item_res']['res_id'] ;
                    $smarty->assign('res', $_SESSION['last_item_res']) ;
                    
                    modORResources::get_keywords_selected($_SESSION['last_item_res']['keywords'], $keywords, $okeywords);
                    
                    $smarty -> assign('okeywords', $okeywords);
                    $smarty -> assign('keywords', $keywords);
                    $smarty->assign('changes', $_SESSION['last_item_res']['changes']);
                    
                    unset($_SESSION['last_item_res']);
                } else {
				    $smarty->assign('res', $res);
                    $smarty -> assign('okeywords', modORResources::get_res_keywords($_GET['item']));
                    $smarty -> assign('keywords', modORResources::get_res_other_keywords($_GET['item']));
                    unset($_SESSION['last_item_res']) ;
                }

				$smarty -> assign('resource', $resource);
				$smarty -> assign('edit', true);
				$TPL_NAME = 'modules'.DIRECTORY_SEPARATOR.$MODULE_NAME.DIRECTORY_SEPARATOR.'submitresource.tpl';
			}
		} elseif (isset($_GET['action']) && $_GET['action'] == 'approve' && isset($_GET['item'])) {
		//approve specified resource
			if ($level > 1) modORMessages::no_admin(); else {
				if (modORResources::set_res_status($_GET['item'], 2))
					modORMessages::msg('Resource approved');
			}
		} elseif (isset($_GET['action']) && $_GET['action'] == 'verify' && isset($_GET['item'])) {
		//verify specified resource
			if ($level > 1) modORMessages::no_admin(); else {
				if (modORResources::set_res_status($_GET['item'], 4))
					modORMessages::msg('Resource verified');
			}
		} elseif (isset($_GET['action']) && $_GET['action'] == 'reject' && isset($_GET['item'])) {
		//reject specified resource
			if ($level > 1) modORMessages::no_admin(); else {
				if (modORResources::set_res_status($_GET['item'], 5))
					modORMessages::msg('Resource verified');
			}
		} elseif (isset($_GET['action']) && $_GET['action'] == 'decline' && isset($_GET['item'])) {
		//decline specified resource (mark as not approved)
			if ($level > 1) modORMessages::no_admin(); else {
				if (modORResources::set_res_status($_GET['item'], 3))
					modORMessages::msg('Resource reported for spam');
			}
		} elseif (isset($_GET['action']) && $_GET['action'] == 'list') {
		//list all resources
			if ($level > 2) modORMessages::no_admin(); else {
                
				if (isset($_GET['item'])) {
					$get_item = $_GET['item'];
                } else {
					$get_item = 1;
                    // BJH - Clear a filter search when they click the 'list resources' link again
                    unset($_SESSION['filter_search']) ;
                }
                
				if (isset($_GET['subitem']) && $_GET['subitem']==0)
					$latest = 'y';
				else
					$latest = 'n';
				$rowcount = 0;
                
                if (isset($_SESSION['filter_search'])) {
                    $resources = modORResources::get_all_resources($_SESSION['filter_search']['status'], $_SESSION['filter_search']['sub_date_from'], $_SESSION['filter_search']['sub_date_to'], $_SESSION['filter_search']['mod_date_from'], $_SESSION['filter_search']['mod_date_to'], $_SESSION['filter_search']['sub_id'], $_SESSION['filter_search']['ver_id'], $_SESSION['filter_search']['app_id'], $_SESSION['filter_search']['mod_id'], ($get_item-1)*ITEMS_PER_PAGE, ITEMS_PER_PAGE, $rowcount) ;
                    $smarty->assign('src', $_SESSION['filter_search']) ;
				} else {
                    $resources = modORResources::get_all_resources('', '', '', '', '', '', '', '', '', ($get_item-1)*ITEMS_PER_PAGE,ITEMS_PER_PAGE,$rowcount,$latest);
                }
                
				if ($rowcount>($get_item*ITEMS_PER_PAGE)) {
					$smarty -> assign('next_id',$get_item+1);
				}
				if ($get_item>1) {
					$smarty -> assign('prev_id',$get_item-1);
				}
                
                if (isset($_SESSION['filter_search'])) {
                    if ($_SESSION['filter_search']['status'] > 0) {
                        $smarty->assign('status', $_SESSION['filter_search']['status']) ;
                    }
                }
                
				$smarty -> assign('resources', $resources);
				$TPL_NAME = 'modules'.DIRECTORY_SEPARATOR.$MODULE_NAME.DIRECTORY_SEPARATOR.'resources.tpl';
			}
		} elseif (isset($_GET['action']) && $_GET['action'] == 'approve') {
		//list resources with submited status
			if ($level > 2) modORMessages::no_admin(); else {
				$smarty -> assign('resources', modORResources::get_all_resources(1));
				$smarty -> assign('status', 1);
				$TPL_NAME = 'modules'.DIRECTORY_SEPARATOR.$MODULE_NAME.DIRECTORY_SEPARATOR.'resources.tpl';
			}
		}elseif (isset($_GET['action']) && $_GET['action'] == 'review') {
		//list resources with approved status
			if ($level > 2) modORMessages::no_admin(); else {
				$smarty -> assign('resources', modORResources::get_all_resources(2));
				$smarty -> assign('status', 2);
				$TPL_NAME = 'modules'.DIRECTORY_SEPARATOR.$MODULE_NAME.DIRECTORY_SEPARATOR.'resources.tpl';
			}
		}elseif (isset($_GET['action']) && $_GET['action'] == 'history' && isset($_GET['item'])) {
			//history of the resource
			if ($level > 0) modORMessages::no_admin(); else {
				$smarty -> assign('states', modORResources::get_resource_changes($_GET['item']));
				$TPL_NAME = 'modules'.DIRECTORY_SEPARATOR.$MODULE_NAME.DIRECTORY_SEPARATOR.'history.tpl';
			}
		} elseif (isset($_GET['action']) && $_GET['action'] == 'hget' && isset($_GET['item']) && isset($_GET['subitem'])) {
			//history state of the resource
			if ($level > 0) modORMessages::no_admin(); else {
				$resource = modORResources::get_resource($_GET['item'], $_GET['subitem']);
				$smarty -> assign('res', $resource);
				
				//get names
				$user_profile = modORProfiles::get_profile($resource['submiter_id']);
				$smarty -> assign('submiter_name', $user_profile['name']);
				$user_profile = modORProfiles::get_profile($resource['verifier_id']);
				$smarty -> assign('verifier_name', $user_profile['name']);
				$user_profile = modORProfiles::get_profile($resource['approver_id']);
				$smarty -> assign('approver_name', $user_profile['name']);
				
				$smarty -> assign('keywords', modORResources::get_res_full_keywords($_GET['item']));
				$smarty -> assign('lnname', modORResources::get_language_name($resource['language_id']));
				$TPL_NAME = 'modules'.DIRECTORY_SEPARATOR.$MODULE_NAME.DIRECTORY_SEPARATOR.'resource.tpl';
			}
		}elseif (isset($_GET['action']) && $_GET['action'] == 'delst' && isset($_GET['item']) && isset($_GET['subitem'])) {
			//delete some history state
			if ($level > 0) modORMessages::no_admin(); else {
				modORResources::del_res_state($_GET['item']);
				$smarty -> assign('states', modORResources::get_resource_changes($_GET['subitem']));
				$TPL_NAME = 'modules'.DIRECTORY_SEPARATOR.$MODULE_NAME.DIRECTORY_SEPARATOR.'history.tpl';
			}
		} elseif (isset($_GET['action']) && $_GET['action'] == 'actst' && isset($_GET['item']) && isset($_GET['subitem'])) {
			//make some history state active
			if ($level > 0) modORMessages::no_admin(); else {
				modORResources::activate_res_state($_GET['item']);
				$smarty -> assign('states', modORResources::get_resource_changes($_GET['subitem']));
				$TPL_NAME = 'modules'.DIRECTORY_SEPARATOR.$MODULE_NAME.DIRECTORY_SEPARATOR.'history.tpl';
			}
		} else {
			//$TPL_NAME = 'modules'.DIRECTORY_SEPARATOR.$MODULE_NAME.DIRECTORY_SEPARATOR.'submitresource.tpl';
		}
	}
}


?>
