<?php
error_reporting(E_ALL);
require_once ('conf/config.inc.php');
require_once (MODULES_DIR.'modORProfiles'.DIRECTORY_SEPARATOR.'modORProfiles.class.php');
require_once (MODULES_DIR.'modORSearch'.DIRECTORY_SEPARATOR.'modORSearch.class.php');
require_once (MODULES_DIR.'modORResources'.DIRECTORY_SEPARATOR.'modORResources.class.php');
require_once (MODULES_DIR.'modORConfigs'.DIRECTORY_SEPARATOR.'modORConfigs.class.php');

function send_admin_notification($mail, $resources)
{

	$message = '
New resources are submitted in '.SITE_NAME.'

total: '.count($resources).'
';

	for ($i = 0; $i < count($resources); $i++)
	{
		
		$message .= $resources[$i]['author'].' - '.$resources[$i]['title'];
		if ($resources[$i]['year']) $message .=' ('.$resources[$i]['year'].')';
		
		$message .= ' ';
		
		if ($resources[$i]['type_id'] == 1) $message .= 'Conference
';
		elseif ($resources[$i]['type_id'] == 2) $message .= 'Journal
';
		elseif ($resources[$i]['type_id'] == 3) $message .= 'Book
';
		elseif ($resources[$i]['type_id'] == 4) $message .= 'Technical Report
';
		elseif ($resources[$i]['type_id'] == 5) $message .= 'Thesis
';
		$message.= 'submitted: '.$resources[$i]['submited_date'].'
';
		$message .= "\n";
	}
	
	$message .= '

-----------------------------------
'.ROOT_URL.'
';
	echo '<pre>';
	echo $mail."\n";
	echo $message;
	echo '</pre><br />';
	if (mail($mail,'ORRD daily admin notification - newly submitted resources',$message,'From: desorrd@cas.mcmaster.ca'))
	return  true;
	else
	return false;
}

function send_to_admin()
{
	$admin = modORProfiles::get_profile(1);
	$a = modORConfigs::get_setting('daily_sub_res');
	if (!empty($a))
	{
		$resources = modORResources::get_all_resources(1, date('Y-m-d', time()-(60*60*24)));
		send_admin_notification($admin['mail'], $resources);
	}
}

send_to_admin();

?>
