<?php
$level = $_SESSION['level'];

//require needed classes
require_once ('modORProfiles.class.php');
require_once (MODULES_DIR.'modORMessages'.DIRECTORY_SEPARATOR.'modORMessages.class.php');
require_once (MODULES_DIR.'modORSearch'.DIRECTORY_SEPARATOR.'modORSearch.class.php');
require_once (MODULES_DIR.'modORConfigs'.DIRECTORY_SEPARATOR.'modORConfigs.class.php');

if ($_SERVER['REQUEST_METHOD'] === 'POST') { 
//here we proceed POST requests
	if (isset($_POST['moduleid']) && $_POST['moduleid'] == 'orp') { //<---- this is the module id
		if (isset($_POST['action']) && $_POST['action'] == 'login' && isset($_POST['mailField']) && isset($_POST['passField'])) //here is the third parameter which is module action 
		{
			if ($user_profile = modORProfiles::login($_POST['mailField'], $_POST['passField'])) {
				//we try to login if account is disabled in session variable name we store 'deactivated'
				if ($_SESSION['name'] == 'deactivated')
				{
					//account is disabled
					modORProfiles::logout();
					modORMessages::msg('Your account is currently disabled. Please contact administrator.', true, SECURE_URL . 'orp/login');
				} else {
					//Login successful - do some additional processing if needed
					//if (isset($_SESSION['referer']))
					//	header('Location: '.$_SESSION['referer']);
				}
			} else {
				//login failed proceed to messages
				modORMessages::msg('Login failed. Please check your username and password and try again.', true, SECURE_URL . 'orp/login');
			}
		}
		elseif (isset($_POST['action']) && $_POST['action'] == 'lost')
		//user submited e-mail for password retrieval
		{
			if (!empty($_POST['mailField']))
			{
				//mail field contains data
				$res = modORProfiles::send_recover($_POST['mailField']);
				if ($res == 0)	{ //user not exists
					modORMessages::msg('This e-mail is not in our database. Please check it again.', true, 'orp/lost');
				}elseif($res == 1) { //mail not send
					modORMessages::msg('E-mail cannot be sent now. Please try again later.', true, 'orp/lost');
				}else { //everything goes fine
					modORMessages::msg('Your account information has been sent. Please check your mailbox.');
				}
			}
			else
			{
				//mail field empty show error message
				modORMessages::msg('Please provide a valid e-mail address.', true, SECURE_URL . 'orp/login');
			}
		}elseif (isset($_POST['action']) && $_POST['action'] == 'invite')
		//admin or full member send invitataion
		{
			if (!empty($_POST['mailField']))
			{
                // BJH - Split by space
                $emails = explode("\n", $_POST['mailField']) ;
                
                $retMsg = "" ;
                
                foreach ($emails as $key => $value) {
                    $value = trim($value) ;
                    if ($value != "") {
				        //mail field contains data
                        $retMsg .= "Attempting to send invite to $value... " ;
				        $res = modORProfiles::send_invitation ($value);
				        if ($res ) { //invitaion sent
                        
					        $retMsg .= "success<br>" ;
				        }
				        else { //error, stop processing
                            $retMsg .= "<b>failed</b>" ;
                            break ;
				        }
                    }
                }
                
                if ($retMsg == "") 
                    modORMessages::msg("No e-mails found.", true, 'orp/invite') ;
                else
                    modORMessages::msg($retMsg, true, 'orp/invite') ;
                
			}
			else
			{
				//mail field empty show error message
				modORMessages::msg('Please provide a valid e-mail address.', true, SECURE_URL . 'orp/login');
			}
		}elseif (isset($_POST['action']) && $_POST['action'] == 'accinv')
		{
			//user accepted invitation and enter his existing username and password
			if (modORProfiles::login($_POST['mail'], $_POST['pass'])){
				if (modORProfiles::check_key($_SESSION['invkey']))
				{
					//account is valid proceed to next stage
					modORProfiles::change_level_tofull($_SESSION['user']);
					//disable temporary key
					modORProfiles::proceed_key($_SESSION['invkey']);
					$_SESSION['level'] = 1;
					$_SESSION['invkey'] = '';
					modORMessages::msg('Your account is now upgraded to full member.');
				}
				else
					modORMessages::msg('Provided key is not valid.');
			}
			else{
				//mail field empty show error message
				modORMessages::msg('Please provide valid login information.');
			}
		}elseif (isset($_POST['action']) && $_POST['action'] == 'register')
		//user request for registration
		{
			if (!empty($_POST['pmail']) && !empty($_POST['ppass']) && !empty($_POST['ppass2']) && !empty($_POST['ppass']) && !empty($_POST['botcapt']))
			{
				//user clicked on register btn
				//all required fields are set
				$botckey = substr($_SESSION['key'],0,5);
				if ($botckey != $_POST['botcapt']){//bot capture code is wrong
					modORMessages::msg('Code from the picture differs from the code you entered. Please try again.', true, SECURE_URL . 'orp/register');
				}
				elseif ($_POST['ppass'] != $_POST['ppass2']){//two passwords are different
					modORMessages::msg('Passwords do not match. Please try again.', true, SECURE_URL . 'orp/register');
					continue;
				}
				elseif ($_SESSION['invkey'] != '') {
					//user accept invitation and register new account
					if (modORProfiles::check_key($_SESSION['invkey']))
					{
						if ($_POST['notify'] == 'on') $ntf = 1; else $ntf = 0;
						
						$id = modORProfiles::register_profile($_POST['pmail'], $_POST['ppass'], '1', $_POST['name'], $ntf, 1);	
						//echo $id;
						
						if ($id && $id != 'user_exists')
						{
							modORProfiles::proceed_key($_SESSION['invkey']);
							$_SESSION['invkey'] = '';
							$smarty -> assign('umail', $_POST['mail']);
							modORMessages::msg('You are successfully registered. You can <a href="'.SECURE_URL.'orp/login">login here</a>');
						}
						else {
							if ($id == 'user_exists') $mssg = 'This e-mail has already been registered';
							modORMessages::msg('You cannot be registered. '.$mssg);
						}
					} else
						modORMessages::msg('Provided key is not valid.');
				} else {
					//it is regular signup, user entered data and pressed signup button
					if ($_POST['notify'] == 'on') $ntf = 1; else $ntf = 0; //make notify boolean
					
					if (modORConfigs::get_setting('signup_confirm')){
					//user must confirm e-mail by pressing link
						$id = modORProfiles::register_profile($_POST['pmail'], $_POST['ppass'], '2', $_POST['name'], $ntf, 0);
						//echo $id;
						
						if ($id  && $id != 'user_exists') {
							modORProfiles::send_confirmation($_POST['pmail'], $id);
							modORMessages::msg('You are successfully registered. But you have to activate your account. You will receive a confirmation email in your mailbox shortly. Click on the link provided in that email so it will confirm your registration.');
						} else {
							echo $id;
							if ($id == 'user_exists') $mssg = 'This e-mail has already been registered';
							modORMessages::msg('You cannot be registered. '.$mssg);
						}
					} else {
						//no need to verify e-mail address
						$id  = modORProfiles::register_profile($_POST['pmail'], $_POST['ppass'], '2', $_POST['name'], $ntf, 1);
						echo $id;
						if ($id  && $id != 'user_exists'){
							//confirmation is off and e-mail is not already registered
							$smarty -> assign('umail', $_POST['mail']);
							modORMessages::msg('You are successfully registered. You can <a href="'.SECURE_URL.'orp/login">login here</a>');
						} else {
								if ($id == 'user_exists') $mssg = 'This e-mail has already been registered';
								modORMessages::msg('You cannot be registered. '.$mssg);
						}
					}
				}
			}
			else
			{
				//mail field empty show error message
				modORMessages::msg('Please complete all required fields.', true, SECURE_URL . 'orp/login');
			}
		}elseif (isset($_POST['action']) && $_POST['action'] == 'filter')
		{
			//admin clicked filter btn
			if ($level > 0) modORMessages::no_admin(); else {
				$users = modORProfiles::get_all_profiles($_POST['start'], $_POST['count'], $_POST['id'], $_POST['mail'], $_POST['type'], $_POST['dt'], $_POST['status']);
				if (is_array($users) && count($users) > 0) 
					$smarty -> assign('users',$users);
				else
					$smarty -> assign('nousr', 'No users found');

				$smarty -> assign('filtered', true);
				$b = ($_POST['start'] > 0);
				$smarty -> assign('prev', $b);
				$n = (modORProfiles::get_profiles_count( $_POST['id'], $_POST['mail'], $_POST['type'], $_POST['dt'], $_POST['status']) > ($_POST['start'] + $_POST['count']));
				$smarty -> assign('next', $n);

				$smarty -> assign('id', $_POST['id']);
				$smarty -> assign('name', $_POST['name']);
				$smarty -> assign('mail', $_POST['mail']);
				$smarty -> assign('type', $_POST['type']);
				$smarty -> assign('count', $_POST['count']);
				$smarty -> assign('dt', $_POST['dt']);
				$smarty -> assign('status', $_POST['status']);
				$start = $_POST['start'];

				$smarty ->assign('startb', ($start-$_POST['count']));
				$smarty ->assign('startn', ($start+$_POST['count']));

				$TPL_NAME = 'modules'.DIRECTORY_SEPARATOR.$MODULE_NAME.DIRECTORY_SEPARATOR.'allprofiles.tpl';
			}
		}elseif (isset($_POST['action']) && $_POST['action'] == 'massaction')
		{
			//some boxes are checked and admin clicked on button
			if ($level > 0) modORMessages::no_admin(); else {
				if ($_POST['submit'] == 'disable') //disable btn clicked
				{
					if (is_array($_POST['selected']) && count(is_array($_POST['selected']) > 0))
					foreach ($_POST['selected'] as $key )
						modORProfiles::deactivate_profile($key);
					modORMessages::msg('Users are disabled', true, 'orp/listprofiles');	
				}elseif ($_POST['submit'] == 'enable') //enable btn clicked
				{
					if (is_array($_POST['selected']) && count(is_array($_POST['selected']) > 0))
					foreach ($_POST['selected'] as $key)
						modORProfiles::activate_profile($key);
					modORMessages::msg('Users are enabled', true, 'orp/listprofiles');	
				}elseif ($_POST['submit'] == 'delete') //delete btn clicked
				{
					if (is_array($_POST['selected']) && count(is_array($_POST['selected']) > 0))
					foreach ($_POST['selected'] as $key)
						modORProfiles::drop_profile($key);
					modORMessages::msg('User(s) were deleted', true, 'orp/listprofiles');	
				}elseif ($_POST['submit'] == 'warn') //warn btn clicked
				{
					if (is_array($_POST['selected']) && count(is_array($_POST['selected']) > 0))
					foreach ($_POST['selected'] as $key)
						modORProfiles::send_warning($key);
					modORMessages::msg('Warning mails are sent', true, 'orp/listprofiles');	
				}
			}
		}elseif (isset($_POST['action']) && $_POST['action'] == 'updateprofile')
		//user updated his own profile
		{
			if ($level != 0 && $_SESSION['user'] != $_POST['id']) modORMessages::no_admin(); else {
				if ($_POST['notify']) $ntf = 1;
				else 
					$ntf = 0;
				$prof = modORProfiles::get_profile($_POST['id']);
				$temp1=$prof['mail'];
				if (modORProfiles::update_profile($_POST['id'], $_POST['mail'], $_POST['level'], $_POST['name'], $ntf ))
				{
					if (!empty($_POST['mail'])) {
 								if (strcmp($temp1,$_POST['mail']) != 0) {                              
								modORProfiles::send_changed_email_confirmation($_POST['mail'],$_POST['id']);
								modORProfiles::deactivate_profile($_POST['id']);
								modORProfiles::logout();
								modORMessages::msg('You have successfully changed your email. Please verify it before using the site');
								exit;
                                                       	} 
						}
					if (!empty($_POST['newpass']) && !empty($_POST['newpass2'])) {
						if (!empty($_POST['pass'])) {
							$prof = modORProfiles::get_profile($_POST['id']);
							if (strcmp($prof['pass'],$_POST['pass']) == 0) {
								modORProfiles::update_profile_pass($_POST['id'], $_POST['newpass']);
							} else {
								modORMessages::msg('Password was not changed. Old password was wrong.', true, SECURE_URL . 'orp/profile');
								exit;
							}
						} else {
							modORMessages::msg('Password was not changed. Please enter the old password before changing it to the new one.', true, SECURE_URL . 'orp/profile');
							exit;
						}
					}
					if ($_POST['notyficriteria'] == '*')
						modORSearch::mark_search_for_notify($_SESSION['user']); // disable all searches
					else
						modORSearch::mark_search_for_notify($_SESSION['user'], $_POST['notyficriteria']); //disable all for user and enable the one selected
						
					modORMessages::msg('Profile updated.');
				}
				else 
					modORMessages::msg('Profile not updated. Please try again later.', true, 'orp/listprofiles');
			}
		}
		
	}
}
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
//here we proceed GET requests
	if (isset($_GET['moduleid']) && $_GET['moduleid'] == 'orp') { //this is the module id
		if (isset($_GET['action']) && $_GET['action'] == 'login') { //this is the module action
			//show login form
			$_SESSION['user'] = (isset($_SESSION['user']))?$_SESSION['user']:'';
			if (($_SESSION['user'] == '')) {
				//show login form
				if (isset($_SERVER['HTTP_REFERER']) && strcmp(substr($_SERVER['HTTP_REFERER'],0,strlen(ROOT_URL)),ROOT_URL) == 0) {
					$_SESSION['referer'] = $_SERVER['HTTP_REFERER'];
				}
				$TPL_NAME = 'modules'.DIRECTORY_SEPARATOR.$MODULE_NAME.DIRECTORY_SEPARATOR.'login.tpl';
			}
			else {
				//already loged in
				modORMessages::msg('You are already logged in. Please <a href="'.ROOT_URL.'orp/logout'.'">logout</a> first.');
			}
			
		} elseif (isset($_GET['action']) && $_GET['action'] == 'logout') {
			//logout request
			modORProfiles::logout();
		}elseif (isset($_GET['action']) && $_GET['action'] == 'lost') {
			//user clicked on lost password link, displaying recover password form
			$TPL_NAME = 'modules'.DIRECTORY_SEPARATOR.$MODULE_NAME.DIRECTORY_SEPARATOR.'lostpass.tpl';
		} elseif (isset($_GET['action']) && $_GET['action'] == 'invite') {
			if ($level > 1)	modORMessages::no_admin(); else {
				$TPL_NAME = 'modules'.DIRECTORY_SEPARATOR.$MODULE_NAME.DIRECTORY_SEPARATOR.'invite.tpl';
			}
		} elseif (isset($_GET['action']) && $_GET['action'] == 'listprofiles') {
			if ($level > 0) 	modORMessages::no_admin(); else {
				$users = modORProfiles::get_all_profiles();
				$smarty -> assign('users',$users);
				$TPL_NAME = 'modules'.DIRECTORY_SEPARATOR.$MODULE_NAME.DIRECTORY_SEPARATOR.'allprofiles.tpl';
			}
		} elseif (isset($_GET['action']) && $_GET['action'] == 'showuser' && isset($_GET['item'])) {
			//list profile
			if ($level > 0) 	modORMessages::no_admin(); else {
				$profile = modORProfiles::get_profile($_GET['item']);
				$smarty -> assign('profile',$profile);
				$TPL_NAME = 'modules'.DIRECTORY_SEPARATOR.$MODULE_NAME.DIRECTORY_SEPARATOR.'profile.tpl';
			}
		} elseif (isset($_GET['action']) && $_GET['action'] == 'verify' && isset($_GET['item'])) {
			//user clicked on the link provided in the invitation mail
			$key = $_GET['item'];
			//check if key is valid
			
			$user_id = modORProfiles::check_act_key($key);
			if ($user_id)
			{
				//key vlaid - proceed
				modORProfiles::activate_profile($user_id);
				modORMessages::msg('You have successfully confirmed your e-mail. You can <a href="'.ROOT_URL.'orp/login">login here</a>');
			}else 
			{
				//key not valid
				modORMessages::msg('This key is not valid. Please provide real key.');
			}
		} elseif (isset($_GET['action']) && $_GET['action'] == 'accinv' && isset($_GET['item'])) {
			//user clicked on the link provided in the confirmation e-mail
			$key = $_GET['item'];
			//check if key is valid
			
			if (modORProfiles::check_key($key))
			{
				//key vlaid - proceed
				$_SESSION['invkey'] = $key;
				$TPL_NAME = 'modules'.DIRECTORY_SEPARATOR.$MODULE_NAME.DIRECTORY_SEPARATOR.'accinvitation.tpl';
			}else 
			{
				//key not valid
				modORMessages::msg('This key is not valid. Please provide real key.');
			}
		} elseif (isset($_GET['action']) && $_GET['action'] == 'deluser' && isset($_GET['item'])) {
			//list profile
			if ($level > 0) modORMessages::no_admin(); else {
				$profile = modORProfiles::drop_profile($_GET['item']);
				$users = modORProfiles::get_all_profiles();
				$smarty -> assign('users',$users);
				$TPL_NAME = 'modules'.DIRECTORY_SEPARATOR.$MODULE_NAME.DIRECTORY_SEPARATOR.'allprofiles.tpl';
			}
		} elseif (isset($_GET['action']) && $_GET['action'] == 'disableuser' && isset($_GET['item'])) {
			//list profile
			if ($level > 0) modORMessages::no_admin(); else {
				$profile = modORProfiles::deactivate_profile($_GET['item']);
				$users = modORProfiles::get_all_profiles();
				$smarty -> assign('users',$users);
				$TPL_NAME = 'modules'.DIRECTORY_SEPARATOR.$MODULE_NAME.DIRECTORY_SEPARATOR.'allprofiles.tpl';
			}
		} elseif (isset($_GET['action']) && $_GET['action'] == 'enableuser' && isset($_GET['item'])) {
			//list profile
			if ($level > 0) modORMessages::	no_admin(); else {
				$profile = modORProfiles::activate_profile($_GET['item']);
				$users = modORProfiles::get_all_profiles();
				$smarty -> assign('users',$users);
				$TPL_NAME = 'modules'.DIRECTORY_SEPARATOR.$MODULE_NAME.DIRECTORY_SEPARATOR.'allprofiles.tpl';
			}
		} elseif (isset($_GET['action']) && $_GET['action'] == 'register') {
			//list profile
			$TPL_NAME = 'modules'.DIRECTORY_SEPARATOR.$MODULE_NAME.DIRECTORY_SEPARATOR.'register.tpl';
			
		} elseif (isset($_GET['action']) && $_GET['action'] == 'profile') {
			if ($level > 3) modORMessages::	no_admin(); else {
				$smarty -> assign('profile',modORProfiles::get_profile($_SESSION['user']));
				$smarty -> assign('searches', modORSearch::get_all_searches($_SESSION['user']));
				$TPL_NAME = 'modules'.DIRECTORY_SEPARATOR.$MODULE_NAME.DIRECTORY_SEPARATOR.'profile.tpl';
			}
		}  elseif (isset($_GET['action']) && $_GET['action'] == 'resign') {
			if ($level == 0) {
				modORMessages::no_admin(); 
			} else {
				if(modORProfiles::deactivate_profile($_SESSION['user'])) {
					modORMessages::msg('You resigned successfully. Your account is now disabled.');
					modORProfiles::logout();
				}
			}
		}

	}
}


?>