<?php
require_once ('conf/config.inc.php');
require_once (MODULES_DIR.'modORProfiles'.DIRECTORY_SEPARATOR.'modORProfiles.class.php');
require_once (MODULES_DIR.'modORSearch'.DIRECTORY_SEPARATOR.'modORSearch.class.php');
require_once (MODULES_DIR.'modORResources'.DIRECTORY_SEPARATOR.'modORResources.class.php');
require_once (MODULES_DIR.'modORConfigs'.DIRECTORY_SEPARATOR.'modORConfigs.class.php');

function send_notification($mail, $resources, $search='')
{	
	
	$message = 'Weekly Email Notification : For your chosen criteria, the following new resources were submited to the '.SITE_NAME.'

total: '.count($resources).'
';
	
	for ($i = 0; $i < count($resources); $i++)
	{
		if ($i == 25)
		{
			$message .= ' ...
';
			continue;
		}
		
		$message .= $resources[$i]['author'].' - '.$resources[$i]['title'];
		if ($resources[$i]['year']) $message .=' ('.$resources[$i]['year'].')';
		
		$message .= ' ';
		
		if ($resources[$i]['type_id'] == 1) $message .= 'Conference
';
		elseif ($resources[$i]['type_id'] == 2) $message .= 'Journal
';
		elseif ($resources[$i]['type_id'] == 3) $message .= 'Book
';
		elseif ($resources[$i]['type_id'] == 4) $message .= 'Technical Report
';
		elseif ($resources[$i]['type_id'] == 5) $message .= 'Thesis
';
		$message.= 'submitted: '.$resources[$i]['submited_date'].' '.round((time()-strtotime($resources[$i]['submited_date']))/(24*60*60),0).' days ago.
';

		$message .= ROOT_URL.'orr/get/'.$resources[$i][id] . "\r\n";
		$message .= "\n";
	}

	if ($search)
		$message .= 'Only the first 25 new submissions are shown.  You can go
to the search page to view the rest. See ORRD help page for details.';
	else 
		$message .= 'Only the first 25 new submissions are shown.  You can go
to the search page to view the rest. See ORRD help page for details.';
	
	$message .= "
To stop this weekly email notification, you have to log in to your
 ORRD account, go to your profile, and uncheck the weekly email
 notification checkbox.
\n\n Thank you\n\n
-----------------------------------
".ROOT_URL."\n";
	echo '<pre>';
	echo $mail."\n";
	echo $message;
	echo '</pre><br />';
	if (@mail($mail,'ORRD : Weekly email notification',$message,'From: desorrd@cas.mcmaster.ca'))
		return  true;
	else
		return  false;
}

function send_to_users()
{

	//first get all profiles
	$users = modORProfiles::get_all_profiles();

	for ($i = 0; $i < count($users); $i++)
	{
		if ($users[$i]['notifications']) //ok user checked notifications
		{
			$search = modORSearch::get_notify_search($users[$i]['id']); // get selected search criteria
			if (!empty($search)) {
				
				$search = $search[0];
				
				//ok user selected search criteria now we filter the results
				$resources = modORSearch::get_all_resources($search['title'], date("Y-m-d", time()-(60*60*24*7)), '', $search['author'], $search['keyword'], $search['type_id'], $search['year'],
						$search['month'], $search['sumtext'], $search['language_id'], $search['jour_name']);
						
				if (is_array($resources) && count($resources) > 0) //ok we have resources send mail								
					send_notification($users[$i]['mail'], $resources, $search);
			} else {
				$resources = modORSearch::get_all_resources('', date("Y-m-d", time()-(60*60*24*7)), '', '', '', '', '', '', '', '', '');
				if (is_array($resources) && count($resources) > 0) //ok we have resources send mail
					send_notification($users[$i]['mail'], $resources);
			}
		}
	}
}

function send_admin_notification($mail, $not_approved, $rejected)
{

	$message = '
Below is weekly count of Not approved and Rejected resources in '.SITE_NAME.'

';
	if ($not_approved)
	$message .= '
	Not approved resources : '.count($not_approved).'
';

////////// Not approved //////////
for ($i=0; $i<count($not_approved);$i++){

		if ($i == 25)
		{
			$message .= ' ...
';
			continue;
		}

		$message .= $not_approved[$i]['author'].' - '.$not_approved[$i]['title'];
		if ($not_approved[$i]['year']) $message .=' ('.$not_approved[$i]['year'].')';
		
		$message .= ' ';
		
		if ($not_approved[$i]['type_id'] == 1) $message .= 'Conference
';
		elseif ($not_approved[$i]['type_id'] == 2) $message .= 'Journal
';
		elseif ($not_approved[$i]['type_id'] == 3) $message .= 'Book
';
		elseif ($not_approved[$i]['type_id'] == 4) $message .= 'Technical Report
';
		elseif ($not_approved[$i]['type_id'] == 5) $message .= 'Thesis
';
		$message.= 'submitted: '.$not_approved[$i]['submited_date'].' '.round((time()-strtotime($not_approved[$i]['submited_date']))/(24*60*60),0).' days ago.
';

		$message .= ROOT_URL.'orr/get/'.$not_approved[$i][id] . "\r\n";
		$message .= "\n";
}
////////// ~ Not approved ~ //////////

	if ($rejected)
	$message .= 
'	Rejected resources : '.count($rejected).'
';

////////// Rejected //////////
for ($i=0; $i<count($rejected);$i++){
		if ($i == 25)
		{
			$message .= ' ...
';
			continue;
		}

		$message .= $rejected[$i]['author'].' - '.$rejected[$i]['title'];
		if ($rejected[$i]['year']) $message .=' ('.$rejected[$i]['year'].')';
		
		$message .= ' ';
		
		if ($rejected[$i]['type_id'] == 1) $message .= 'Conference
';
		elseif ($rejected[$i]['type_id'] == 2) $message .= 'Journal
';
		elseif ($rejected[$i]['type_id'] == 3) $message .= 'Book
';
		elseif ($rejected[$i]['type_id'] == 4) $message .= 'Technical Report
';
		elseif ($rejected[$i]['type_id'] == 5) $message .= 'Thesis
';
		$message.= 'submitted: '.$rejected[$i]['submited_date'].' '.round((time()-strtotime($rejected[$i]['submited_date']))/(24*60*60),0).' days ago.
';

		$message .= ROOT_URL.'orr/get/'.$rejected[$i][id] . "\r\n";
		$message .= "\n";
}
////////// ~ Rejected ~ //////////



	$message .= '
-----------------------------------
'.ROOT_URL.'
';
	if (@mail($mail,'ORRD weekly admin notification - Not Approved and Rejected resources',$message,'From: desorrd@cas.mcmaster.ca'))
	return  true;
		else
	return false;
}

function send_to_admin()
{
	$admin = modORProfiles::get_profile(1);
	$a = modORConfigs::get_setting('weekly_na_res');
	$b = modORConfigs::get_setting('weekly_rej_res');
	if ($a)
	{
		$not_approved = modORResources::get_all_resources(3, date("Y-m-d", time()-(60*60*24*7)));
	}
	if ($b)
	{
		$rejected = modORResources::get_all_resources(5, date("Y-m-d", time()-(60*60*24*7)));
	}

	if ($a || $b)
		send_admin_notification($admin['mail'], $not_approved, $rejected);	

}

send_to_users();
send_to_admin();

?>
