<?php
class modORSearch {

	function get_all_resources($title = '', $sub_from = '', $sub_to = '', $author = '', $keyword = '', $type_id = '', $year_from = '', $year_to = '', $month_from = '', $month_to = '', $summary = '', $language = '', $jour_name = '', $rank_from='', $rank_to='', $start = 0, $count = -1, &$rowcount=0, $lastweek='n')
	//get resources matching search criteria
	{
        // BJH - Commented out to try and match only records that have all keywords
        //$keyword_tbl = "" ;

        
        // BJH - LEFT JOIN alternative to the keyword search
        if (trim($keyword)) {
            $keyword_list = split(" ", trim(str_replace(',', ' ', $keyword))) ;
            
            $found = false ;

            $keyword_tbl = " LEFT JOIN tbl_mod_resource_reskeywords rk ON rk.`res_id` = r.`id` 
                 LEFT JOIN tbl_mod_resource_keywords rw ON rw.id = rk.keyword_id AND (" ;

            
            foreach ($keyword_list as $key => $value) {
                $value = trim($value) ;
                if ($value != '') {
                    if (!$found) {
                        $keyword_tbl .= " rw.word LIKE '%$value%' " ;
                        $found = true ;
                    } else {
                        $keyword_tbl .= " OR rw.word LIKE '%$value%' " ;
                    }
                }
            }
     
            if (!$found) 
                $keyword_tbl = "" ;
            else
                $keyword_tbl .= " )" ;
        
        } else {
            $keyword_tbl = "" ;
        }
                
        // BJH - Added Distinct to compensate for keyword fix
		$sql = "SELECT DISTINCT r.`id`, rd.`type_id`, r.`status`, r.`submited_date`, r.`submiter_id`, r.`approved_date`, r.`approver_id`, r.`verified_date`, r.`verifier_id`, r.`rank`, 
		               rd.`res_id`, rd.`last`, rd.`mod_date`, rd.`mod_id`, rd.`changes`, rd.`title`, rd.`author`, rd.`year`, rd.`summary`, rd.`language_id`, rd.`ol_summary`, rd.`url`, rd.`note`, rd.`month`, rd.`custom_keywords`, 
		               rd.`con_name`, rd.`con_place`, rd.`con_pages`, rd.`jour_name`, rd.`jour_vol_no`, rd.`jour_pages`, rd.`jour_issue`, rd.`jour_month`, rd.`b_place`, rd.`b_publisher`, 
		               rd.`b_isbn`, rd.`tr_type`, rd.`tr_inst_name`, rd.`tr_inst_addr`, rd.`tr_report_no`, 
		               rd.`th_label`, rd.`th_school_addr`, rd.`th_department`
				FROM tbl_mod_resource r JOIN tbl_mod_resource_data rd 
					 ON r.id = rd.res_id
                     $keyword_tbl
				WHERE rd.last=1
				";
                
		/* Doesn't work under MySQL 4.0.x Series
		if ($keyword) $sql .= " AND ('$keyword' IN (SELECT rw.word 
								                	FROM tbl_mod_resource_reskeywords rk
								                    	LEFT JOIN tbl_mod_resource_keywords rw
											 			ON rw.id = rk.keyword_id
											 		WHERE rk.`res_id` = r.`id`))";
		
		
        // BJH - *** Should this be included?  Was commented out but it appears it would work under MySQL 4.0.x...  
		if ((!isset($_SESSION['level'])  || $_SESSION['level'] > 1) || ($_SESSION['level'] == ''))
			$sql .= " AND (r.`status` = 2 OR r.`status` = 4)";
		*/	
		
        // BJH - Only return records with the keyword in it if entered
        
        if (trim($keyword)) {
            /*// New keyword loop to return records that match all keywords
            $keyword_list = split(" ", trim(str_replace(',' , ' ', $keyword))) ;

            foreach ($keyword_list as $key => $value) {
                $value = trim($value) ;
                if ($value != '') {

                    $sql .= " AND ( '$value' IN (SELECT rw.word 
                                                FROM tbl_mod_resource_reskeywords rk
                                                    LEFT JOIN tbl_mod_resource_keywords rw
                                                     ON rw.id = rk.keyword_id
                                                 WHERE rk.`res_id` = r.`id`) OR rd.`custom_keywords` LIKE '%$value%' ) " ;
                }
            } */
            
            $sql .= " AND ( rw.word IS NOT NULL " ; 
            $keyword_list = split(" ", trim(str_replace(',', ' ', $keyword))) ;
            
            $found = false ;
            
            foreach ($keyword_list as $key => $value) {
                $value = trim($value) ;
                if ($value != '') {
                    if (!$found) {
                        $sql .= " OR (  rd.`custom_keywords` LIKE '%$value%' " ;
                        $found = true ;
                    } else {
                        $sql .= " OR rd.`custom_keywords` LIKE '%$value%' " ;
                    }
                }
            }
            
            if ($found)
                $sql .= " ))" ;
            else
                $sql .= " )" ;
        }

        
		if ($title) $sql .= " AND ( rd.`title` LIKE '%$title%')";
		if ($sub_from) $sql .= " AND ( TO_DAYS(r.`submited_date`) >= TO_DAYS('$sub_from'))";
		if ($sub_to) $sql .= " AND ( TO_DAYS(r.`submited_date`) <= TO_DAYS('$sub_to'))";
		if ($author) $sql .= " AND ( rd.`author` LIKE '%$author%')";
		
		if ($type_id) $sql .= " AND ( rd.`type_id` = '$type_id')";
		if ($year_from) $sql .= " AND ( rd.`year` >= $year_from)";
		if ($year_to) $sql .= " AND ( rd.`year` <= $year_to)";
		
		if ($month_from) $sql .= " AND ( rd.`month` >= $month_from)";
		if ($month_to) $sql .= " AND ( rd.`month` <= $month_to)";
		if ($summary) $sql .= " AND ( rd.`summary` LIKE '%$summary%')";
		if ($language != "") $sql .= " AND ( rd.`language_id` = '$language')";
		if ($jour_name) $sql .= " AND ( rd.`jour_name` LIKE '%$jour_name%')";
		if ($rank_from) $sql .= " AND (r.`rank` >= $rank_from)";
		if ($rank_to) $sql .= " AND (r.`rank` <= $rank_to)";
		//Last week

		if ($lastweek == 'y' && $sub_from == '' && $sub_to == '')
			$sql .= " AND (TO_DAYS(r.`submited_date`) > (TO_DAYS(NOW())-7))";
		$sql .= " ORDER BY rd.`year` DESC, rd.`month` DESC";
		
        //echo $sql ;
        
		$res = mysql_query($sql);
		$i = 0;
       
		$rowcount = mysql_num_rows($res);
		
		while ($row = mysql_fetch_assoc($res))
		{
			if ($row['type_id'] == 1)
			$row['type'] = 'Conference';
			elseif ($row['type_id'] == 2)
			$row['type'] = 'Journal';
			elseif ($row['type_id'] == 3)
			$row['type'] = 'Book';
			elseif ($row['type_id'] == 4)
			$row['type'] = 'Technical Report';
			elseif ($row['type_id'] == 5)
			$row['type'] = 'Thesis';
			//MySQL 4.0.x Fix
            // BJH - Fixed using LEFT JOIN above
            /*
			if ($keyword) {
				$sql = "SELECT rw.word 
	                	FROM tbl_mod_resource_reskeywords rk
	                    LEFT JOIN tbl_mod_resource_keywords rw
				 		ON rw.id = rk.keyword_id
				 		WHERE rk.`res_id` = ".$row['res_id'];
				$wordres = mysql_query($sql);
				$j = 0;
				while ($wordrow = mysql_fetch_assoc($wordres)) {
					$words[$j++] = $wordrow['word'];
				}
				$pos = (strpos($row['custom_keywords'],$keyword));
				if ($pos === FALSE) 
					$pos = -1;
				if ((isset($words) && in_array($keyword,$words)) || $pos>=0) {
					$row['keywords'] = modORResources::get_res_full_keywords($row['id']);
					$result[$i++] = $row;
				}
			} else {
            
				$row['keywords'] = modORResources::get_res_full_keywords($row['id']);
				$result[$i++] = $row;
			}
            */
            
            // Get all the keywords for this record
            $row['keywords'] = modORResources::get_res_full_keywords($row['id']);
            
            // BJH - verify that all keywords are included before adding to result set
            $missing = false ;
            
            if (trim($keyword)) {
                $keyword_list = split(" ", trim(str_replace(',', ' ', $keyword))) ;
                
                foreach ($keyword_list as $key => $value) {
                    $value = trim($value) ;
                    if ($value != '') {
                        // see if this value matches one of the found values
                        $found = false ;
                        foreach (explode(' ', $row['keywords']) as $f_key => $f_value) {
                            if (strstr(strtolower($f_value), strtolower($value)) !== FALSE) {
                                $found = true ;
                                break ;
                            }
                        }
                        
                        if (!$found) {
                            $missing = true ;
                            break ;
                        }   
                    }
                }
            }
            
            if (!$missing)
                $result[$i++] = $row;
		}
		
		if ($count != -1 && isset($result)) {
			$result = array_slice($result,$start,$count);
		}
			
		if (isset($result)) return $result;
		else return false;
	}
	
	function get_all_resources_simple_search($text)
	//first page simple search
	{
		$sql = "SELECT r.`id`, rd.`type_id`, r.`status`, r.`submited_date`, r.`submiter_id`, r.`approved_date`, r.`approver_id`, r.`verified_date`, r.`verifier_id`, r.`rank`, 
		               rd.`res_id`, rd.`last`, rd.`mod_date`, rd.`mod_id`, rd.`changes`, rd.`title`, rd.`author`, rd.`year`, rd.`summary`, rd.`language_id`, rd.`ol_summary`, rd.`url`, rd.`note`, rd.`month`, rd.`custom_keywords`, 
		               rd.`con_name`, rd.`con_place`, rd.`con_pages`, rd.`jour_name`, rd.`jour_vol_no`, rd.`jour_pages`, rd.`jour_issue`, rd.`jour_month`, rd.`b_place`, rd.`b_publisher`, 
		               rd.`b_isbn`, rd.`tr_type`, rd.`tr_inst_name`, rd.`tr_inst_addr`, rd.`tr_report_no`, 
		               rd.`th_label`, rd.`th_school_addr`, rd.`th_department`
				FROM tbl_mod_resource r JOIN tbl_mod_resource_data rd 
					 ON r.id = rd.res_id
				WHERE rd.last=1
				";
		/*
		if ($text) $sql .= " AND (('$text' IN (SELECT rw.word 
								                	FROM tbl_mod_resource_reskeywords rk
								                    	LEFT JOIN tbl_mod_resource_keywords rw
											 			ON rw.id = rk.keyword_id
											 		WHERE rk.`res_id` = r.`id`))
								 OR ( rd.`title` LIKE '%$text%')
								 OR ( rd.`author` LIKE '%$text%')
								 OR ( rd.`summary` LIKE '%$text%')
								 OR ( rd.`jour_name` = '$text')
							)";
		*/
		if ($text) $sql .= " AND (( rd.`title` LIKE '%$text%')
								 OR ( rd.`author` LIKE '%$text%')
								 OR ( rd.`summary` LIKE '%$text%')
								 OR ( rd.`jour_name` = '$text')
							)";
		if ($_SESSION['level'] > 1  || (!isset($_SESSION['level'])) || ($_SESSION['level'] == ''))
			$sql .= " AND (r.`status` = 2 OR r.`status` = 4)";
		
		$sql .= " ORDER BY rd.`year` DESC, rd.`month` DESC";
		$res = mysql_query($sql);
		$i = 0;
		while ($row = mysql_fetch_assoc($res))
		{
			if ($row['type_id'] == 1)
			$row['type'] = 'Conference';
			elseif ($row['type_id'] == 2)
			$row['type'] = 'Journal';
			elseif ($row['type_id'] == 3)
			$row['type'] = 'Book';
			elseif ($row['type_id'] == 4)
			$row['type'] = 'Technical Report';
			elseif ($row['type_id'] == 5)
			$row['type'] = 'Thesis';
			
			$row['keywords'] = modORResources::get_res_full_keywords($row['id']);
			
			$result[$i++] = $row;
		}
		if (isset($result)) return $result;
		else return false;
	}
	
	function save_search($name, $title, $sub_from, $sub_to, $author, $keyword, $type_id, $year_from, $year_to, $month_from, $month_to, $summary, $language, $jour_name, $rank_from, $rank_to)
	//save user search
	{
		$sql = "INSERT INTO tbl_mod_search (`id`, `usr_id`, `name`, `title`, `from`, `to`, `author`, `keyword`, `type`, `year_from`, `year_to`, `month_from`, `month_to`, `summary`, `language`, `jour_name`, `notify`, `rank_from`, `rank_to`)
				VALUES ('0', '".$_SESSION['user']."', '$name', '$title', '$sub_from', '$sub_to', '$author', '$keyword', '$type_id', '$year_from', '$year_to', '$month_from', '$month_to', '$summary', '$language', '$jour_name', 0, '$rank_from', '$rank_to')
				";
		$res = mysql_query($sql);
		if ($res) return true;
		else 
		return false;
	}
	
	function get_all_searches($usr = '')
	//get all searches for specified user
	{
		$sql = "SELECT `id`, `usr_id`, `name`, `title`, `from` as `sub_from`, `to` as `sub_to`, `author`, `keyword`, `type` as `type_id`, `year_from`, `year_to`, `month_from`, `month_to`, `summary` as `sumtext`, `language` as `language_id`, `jour_name`, `notify`, `rank_from`, `rank_to`
					FROM `tbl_mod_search` ";
		if ($usr)
			$sql .=   "	WHERE `usr_id` = '".$usr."'";
		$res = mysql_query($sql);
		$i = 0;
		while ($row = mysql_fetch_assoc($res))
			$result[$i++] = $row;

		if (isset($result)) return $result;
		else
		return false;
	}
	
	//used when sending notification e-mails
	function get_notify_search($usr)
	//get search criteria, selected for weekly notification
	{
		$sql = "SELECT `id`, `usr_id`, `name`, `title`, `from` as `sub_from`, `to` as `sub_to`, `author`, `keyword`, `type` as `type_id`, `year_from`, `year_to`, `month_from`, `month_to`, `summary` as `sumtext`, `language` as `language_id`, `jour_name`, `notify`, `rank_from`, `rank_to`
					FROM `tbl_mod_search`
					WHERE `usr_id` = '".$usr."'
					AND `notify` = 1";
		
		$res = mysql_query($sql);
		//echo $sql.mysql_error();
		$i = 0;
		while ($row = mysql_fetch_assoc($res))
			$result[$i++] = $row;

		if (isset($result)) return $result;
		else
		return false;
	}
	
	function get_search($id)
	//load search
	{
		$sql = "SELECT `id`, `usr_id`, `name`, `title`, `from` as `sub_from`, `to` as `sub_to`, `author`, `keyword`, `type` as `type_id`, `year_from`, `year_to`, `month_from`, `month_to`, `summary` as `sumtext`, `language` as `language_id`, `jour_name`, `notify`, `rank_from`, `rank_to`
					FROM `tbl_mod_search`
					WHERE `id` = '$id'
				";
		$res = mysql_query($sql);
		if ($res)
			return mysql_fetch_assoc($res);
		else
			return false;
	}
	
	function delete_search($id)
	//delete search
	{
		$sql = "DELETE FROM `tbl_mod_search`
				WHERE `id` = '$id'";
		$res = mysql_query($sql);
		if ($res) return true;
		else return false;
	}
	
	function mark_search_for_notify($usr, $id = '')
	//set search for weekly notification
	{
		$sql = "UPDATE `tbl_mod_search` SET `notify` = 0 WHERE `usr_id` = '$usr'";
		$res = mysql_query($sql);
		
		if ($id)
		{
			$sql = "UPDATE `tbl_mod_search` SET `notify` = 1 WHERE `id` = '$id'";
			$res = mysql_query($sql);
		}
		if ($res) return true;
		else return false;
	}
    
    function format_month($month) {
        $published_month = '' ;
        
        switch ($month) {
            case (1):
                $published_month = 'Jan.' ;
                break ;
            case (2):
                $published_month = 'Feb.' ;
                break ;
            case (3):
                $published_month = 'Mar.' ;
                break ;
            case (4):
                $published_month = 'Apr.' ;
                break ;
            case (5):
                $published_month = 'May' ;
                break ;
            case (6):
                $published_month = 'Jun.' ;
                break ;
            case (7):
                $published_month = 'Jul.' ;
                break ;
            case (8):
                $published_month = 'Aug.' ;
                break ;
            case (9):
                $published_month = 'Sep.' ;
                break ;
            case (10):
                $published_month = 'Oct.' ;
                break ;
            case (11):
                $published_month = 'Nov.' ;
                break ;
            case (12):
                $published_month = 'Dec.' ;
                break ;
        }
        
        return $published_month ;
    }
    
    function get_bibtex_code($id_list) {
        // BJH - Get the bibtex code for the given array of resource id's
        $ret = "" ;
        
        if (is_array($id_list) && count($id_list) > 0) {
            $ids = implode(",", $id_list) ;
            
            $sql = "SELECT DISTINCT r.`id`, rd.`type_id`, r.`status`, r.`submited_date`, r.`submiter_id`, r.`approved_date`, r.`approver_id`, r.`verified_date`, r.`verifier_id`, r.`rank`, 
                           rd.`res_id`, rd.`last`, rd.`mod_date`, rd.`mod_id`, rd.`changes`, rd.`title`, rd.`author`, rd.`year`, rd.`summary`, rd.`language_id`, rd.`ol_summary`, rd.`url`, rd.`note`, rd.`month`, rd.`custom_keywords`, 
                           rd.`con_name`, rd.`con_place`, rd.`con_pages`, rd.`jour_name`, rd.`jour_vol_no`, rd.`jour_pages`, rd.`jour_issue`, rd.`jour_month`, rd.`b_place`, rd.`b_publisher`, 
                           rd.`b_isbn`, rd.`tr_type`, rd.`tr_inst_name`, rd.`tr_inst_addr`, rd.`tr_report_no`, 
                           rd.`th_label`, rd.`th_school_addr`, rd.`th_department`
                    FROM tbl_mod_resource r JOIN tbl_mod_resource_data rd 
                         ON r.id = rd.res_id
                         $keyword_tbl
                    WHERE rd.last=1 AND r.`id` IN ($ids)
                    ORDER BY rd.`year` DESC, rd.`month` DESC " ;
                    
            $res = mysql_query($sql) ;
            
            if ($res) {
                while ($row = mysql_fetch_array($res)) {
                    
                    extract($row) ;
                    
                    // Format the name(s) if possible
                    $authors = "" ;
                    $lastnames = "" ;
                    
                    $i = 0 ;
                    
                    $comma_split = explode(",", $author) ;
                    
                    foreach ($comma_split as $c_key => $c_value) {
                        $and_split = explode(" and ", $c_value) ;
                        
                        foreach ($and_split as $a_key => $a_value) {
                            $a_value = trim($a_value) ;
                            
                            if ($a_value != '') {
                                $authors[$i] = $a_value ;
                                $space_split = explode(" ", $a_value) ;
                                $lastnames[$i] = $space_split[count($space_split) - 1] ;
                                $i++ ;
                            }
                        }
                    }
                    
                    $author_last_names = implode("", $lastnames) ;
                    $author_names = implode(" and ", $authors) ;
                    
                    $published_month = modORSearch::format_month($month) ;
                                     
                    switch ((int)$type_id) {
                        case (1) :
                            // (6) Conference
                            $ret .= 
"@InProceedings{Conf$author_last_names$year,
  author = {{$author_names}},
  title = {{$title}},
  booktitle = {Proc. of $con_name},
  address = {{$con_place}},
  pages = {{$con_pages}}" ;
                            
                            if ($published_month != '')
                                $ret .= ",
  month = {{$published_month}}" ;
  
                            if (trim($note) != '')
                                $ret .= ",
  note = {{$note}}" ;
  
                            $ret .= ",
  year = $year
}

" ;

                            break ;
                        case (2) :
                            // (5) Journal
                            $ret .= 
"@Article{Journ$author_last_names$year,
  author = {{$author_names}},
  title = {{$title}},
  journal = {{$jour_name}},
  volume = $jour_vol_no,
  number = $jour_issue,
  pages = {{$jour_pages}}" ;
                            
                            if ($published_month != '')
                                $ret .= ",
  month = {{$published_month}}" ;
  
                            if (trim($note) != '')
                                $ret .= ",
  note = {{$note}}" ;
  
                            $ret .= ",
  year = $year
}

" ;
                            
                            break ;
                        case (3) :
                            // (1) Book
                              
                            $ret .= 
"@Book{Book$author_last_names$year,
  author = {{$author_names}},
  title = {{$title}},
  publisher = {{$b_publisher}}" ;
                            
                            if ($published_month != '')
                                $ret .= ",
  month = {{$published_month}}" ;
  
                            if (trim($b_place) != '')
                                $ret .= ",
  address = {{$b_place}}" ;
  
                            if (trim($note) != '')
                                $ret .= ",
  note = {{$note}}" ;
  
                            $ret .= ",
  year = $year
}

" ;
                            break ;
                        case (4) :
                            // (4) Technical Report
                            $ret .= 
"@TechReport{TR$author_last_names$year,
  author = {{$author_names}},
  title = {{$title}},
  institution = {{$tr_inst_name}},
  address = {{$tr_inst_addr}},
  number = {{$tr_report_no}}" ;
                            
                            if (trim($tr_type))
                                $ret .= ",
  type = {{$tr_type}}" ;
                            
                            if ($published_month != '')
                                $ret .= ",
  month = {{$published_month}}" ;
  
                            if (trim($note) != '')
                                $ret .= ",
  note = {{$note}}" ;
  
                            $ret .= ",
  year = $year
}

" ;

                            break ;
                        case (5) :
                            // Thesis
                            if (!(strpos($th_label, 'Doctor') === FALSE)) {
                                // (2) PHD Thesis
                                $ret .= 
"@PhdThesis{PhD$author_last_names$year,
  author = {{$author_names}},
  title = {{$title}},
  school = {{$th_department}},
  address = {{$th_school_addr}}" ;
                            
                            if ($published_month != '')
                                $ret .= ",
  month = {{$published_month}}" ;
  
                            if (trim($note) != '')
                                $ret .= ",
  note = {{$note}}" ;
  
                            $ret .= ",
  year = $year
}

" ;
                                
                            } elseif (!(strpos($th_label, 'Master') === FALSE)) {
                                // (3) Master's Thesis
                                $ret .= 
"@MastersThesis{Mstr$author_last_names$year,
  author = {{$author_names}},
  title = {{$title}},
  school = {{$th_department}},
  address = {{$th_school_addr}}" ;
                            
                            if ($published_month != '')
                                $ret .= ",
  month = {{$published_month}}" ;
  
                            if (trim($note) != '')
                                $ret .= ",
  note = {{$note}}" ;
  
                            $ret .= ",
  year = $year
}

" ;
                            }
                            break ;
                    }
                    
                    
                }
            }
        }
        
        return $ret ;
    }
}
?>