/* redtrap.c */

#include <stdio.h>
#include "mpi.h"

extern void Get_data2(double* a_ptr, double* b_ptr, int* n_ptr, int my_rank);
extern double Trap(double local_a, double local_b, int local_n, double h);   

int main(int argc, char** argv) 
{
  int         my_rank, p;
  double      a, b, h;
  int         n;         
  double      local_a, local_b, local_n;  
  double      integral;  
  double      total;     
  
  MPI_Init(&argc, &argv);
  MPI_Comm_rank(MPI_COMM_WORLD, &my_rank);
  MPI_Comm_size(MPI_COMM_WORLD, &p);
  
  Get_data2(&a, &b, &n, my_rank);
  
  h = (b-a)/n;   
  local_n = n/p; 
  
  local_a = a + my_rank*local_n*h;
  local_b = local_a + local_n*h;
  integral = Trap(local_a, local_b, local_n, h);
  
  /* Add up the integrals calculated by each process */
  MPI_Reduce(&integral, &total, 1, MPI_DOUBLE, MPI_SUM, 0, MPI_COMM_WORLD);
  
  if (my_rank == 0) 
    {
      printf("With n = %d trapezoids, our estimate\n", n);
      printf("of the integral from %f to %f = %f\n", a, b, total); 
    }
  
  MPI_Finalize();
  return 0;
}
