/* getdata.c
 * Reads in the user input a, b, and n.
 * Input parameters:
 *     1.  int my_rank:  rank of current process.
 *     2.  int p:  number of processes.
 * Output parameters:  
 *     1.  double* a_ptr:  pointer to left endpoint a.
 *     2.  double* b_ptr:  pointer to right endpoint b.
 *     3.  int* n_ptr:  pointer to number of trapezoids.
 * Algorithm:
 *     1.  Process 0 prompts user for input and
 *         reads in the values.
 *     2.  Process 0 sends input values to other
 *         processes.
 */
#include <stdio.h>
#include "mpi.h"

void Get_data( double* a_ptr, double* b_ptr, int* n_ptr, 
	       int my_rank, int p )
{ 
  int source = 0, dest, tag;
  MPI_Status status;
    
  if (my_rank == 0)
    {
      printf("Rank %d: Enter a, b, and n\n", my_rank);
      scanf("%lf %lf %d", a_ptr, b_ptr, n_ptr);  
      
      for (dest = 1; dest < p; dest++)
	{
	  tag = 0;
	  MPI_Send(a_ptr, 1, MPI_DOUBLE, dest, tag, 
		   MPI_COMM_WORLD);
	  tag = 1;
	  MPI_Send(b_ptr, 1, MPI_DOUBLE, dest, tag, 
		   MPI_COMM_WORLD);
	  tag = 2;
	  MPI_Send(n_ptr, 1, MPI_INT, dest, tag, 
		   MPI_COMM_WORLD);
        }
    } 
  else 
    {
      tag = 0;
      MPI_Recv(a_ptr, 1, MPI_DOUBLE, source, tag, 
	       MPI_COMM_WORLD, &status);
      tag = 1;
      MPI_Recv(b_ptr, 1, MPI_DOUBLE, source, tag, 
	       MPI_COMM_WORLD, &status);
      tag = 2;
      MPI_Recv(n_ptr, 1, MPI_INT, source, tag, 
	       MPI_COMM_WORLD, &status);
    }
} 
