/* get_data.c -- Parallel Trapezoidal Rule, 
   uses basic Get_data function for input.
*/

#include <stdio.h>
#include "mpi.h"

extern void Get_data(double* a_ptr, double* b_ptr, int* n_ptr, int my_rank, int p);
extern double Trap(double a, double b, int n, double h);

int main(int argc, char** argv) 
{
  int         my_rank, p;
  double      a, b, h;
  int         n;       
  double      local_a, local_b;
  int         local_n;   
  
  double      integral;  
  double      total=-1;  
  int         source, dest = 0, tag = 0;
  MPI_Status  status;
  
  MPI_Init(&argc, &argv);
  
  MPI_Comm_rank(MPI_COMM_WORLD, &my_rank);
  MPI_Comm_size(MPI_COMM_WORLD, &p);
  
  Get_data(&a, &b, &n, my_rank, p);
  
  h = (b-a)/n;    /* h is the same for all processes */
  local_n = n/p;  /* So is the number of trapezoids */
  
  local_a = a + my_rank*local_n*h;
  local_b = local_a + local_n*h;
  integral = Trap(local_a, local_b, local_n, h);

  if (my_rank == 0) 
    {
      total = integral;
      for (source = 1; source < p; source++) 
	{
	  MPI_Recv(&integral, 1, MPI_DOUBLE, source, tag, MPI_COMM_WORLD, &status);
	  total = total + integral;
        }
    } 
  else 
    MPI_Send(&integral, 1, MPI_DOUBLE, dest, tag, MPI_COMM_WORLD);

  if (my_rank == 0) 
    {
      printf("With n = %d trapezoids, our estimate\n", n);
      printf("of the integral from %f to %f = %f\n", a, b, total); 
    }
  
  MPI_Finalize();
  return 0;
} 

