/* get_data.c -- Parallel Trapezoidal Rule, 
   uses basic Get_data function for input.
*/

#include <stdio.h>
#include "mpi.h"

extern void Get_data(float* a_ptr, float* b_ptr, 
		     int* n_ptr, int my_rank, int p);
extern float Trap(float a, float b, int n, float h);

int main(int argc, char** argv) 
{
  int         my_rank, p;
  float       a, b, h;
  int         n;       
  float       local_a, local_b;
  int         local_n;   
  
  float       integral;  
  float       total=-1;  
  int         source, dest = 0, tag = 0;
  MPI_Status  status;


  
  MPI_Init(&argc, &argv);
  
  MPI_Comm_rank(MPI_COMM_WORLD, &my_rank);
  MPI_Comm_size(MPI_COMM_WORLD, &p);
  
  Get_data(&a, &b, &n, my_rank, p);
  
  h = (b-a)/n;    /* h is the same for all processes */
  local_n = n/p;  /* So is the number of trapezoids */
  
  /* Length of each process' interval of 
   * integration = local_n*h.  So my interval
   * starts at: */
  local_a = a + my_rank*local_n*h;
  local_b = local_a + local_n*h;
  integral = Trap(local_a, local_b, local_n, h);

  






  /* Add up the integrals calculated by each process */
  if (my_rank == 0) 
    {
      total = integral;
      for (source = 1; source < p; source++) 
	{
	  MPI_Recv(&integral, 1, MPI_FLOAT, source, tag, 
		   MPI_COMM_WORLD, &status);
	  total = total + integral;
        }
    } 
  else 
    MPI_Send(&integral, 1, MPI_FLOAT, dest, 
	     tag, MPI_COMM_WORLD);
  /* Print the result */
  if (my_rank == 0) 
    {
      printf("With n = %d trapezoids, our estimate\n", n);
      printf("of the integral from %f to %f = %f\n", 
	     a, b, total); 
    }
  
  MPI_Finalize();
  return 0;
} 

