/* mess.c */
#include <stdio.h>
#include <stdlib.h>
#include "mpi.h"

#define BUF_SIZE 100

int main(int argc, char* argv[]) 
{
  int my_rank, npes;
  char *sendbuf, *recvbuf;
  MPI_Status status;

  MPI_Init(&argc, &argv);
  MPI_Comm_size(MPI_COMM_WORLD, &npes);
  MPI_Comm_rank(MPI_COMM_WORLD, &my_rank);

  sendbuf = malloc(BUF_SIZE);
  recvbuf = malloc(BUF_SIZE);

  if (my_rank==0)
    {
      MPI_Send(sendbuf, BUF_SIZE, MPI_CHAR, 1,
	       0,MPI_COMM_WORLD);
      MPI_Recv(recvbuf, BUF_SIZE, MPI_CHAR, 1,
	       0,MPI_COMM_WORLD,&status);
    }
  if (my_rank==1)
    {

      MPI_Send(sendbuf, BUF_SIZE, MPI_CHAR, 0,
	       0,MPI_COMM_WORLD);
      MPI_Recv(recvbuf, BUF_SIZE, MPI_CHAR, 0,
	       0,MPI_COMM_WORLD,&status);
    }

  free(recvbuf);
  free(sendbuf);
  printf(" *** PE %d done \n", my_rank);

  MPI_Finalize();
  return 0;
} 
