// FILE DemoLorenz.cc

#include "VNODE.h"  
#include "Lorenz.h" 

int main()
{
  // Initialize VNODE.
  VnodeInit();  
  
  // Create the ODE problem and the data representation object.
  PtrODENumeric ODE = new Lorenz; 
  PtrDataRepr DataRepr = new TAYLOR_EXPANSION<LorenzTaylGenODE,LorenzTaylGenVAR>;
  
  // Set the problem parameters.
  ODE->LoadProblemParam(1); 
  
  // Create a solver.
  PtrODESolver Solver = new SOLVER_2( ODE, DataRepr ); 
  
  // The solution will be plotted. 
  Solver->GraphOutput(true); 
  
  cout << endl << "*** Integrating " << ODE->GetName() << endl;
  Solver -> Integrate();
  
  cout << endl << "   Enclosure at T = " << INTERVAL(ODE->GetTcur()) << endl;
  PrintVec( ODE->GetTightEncl() );

  // Plot Y(1) vs. t.
  ODE->DisplaySolution(1); 

  // Save this plot in Lorenz.eps.
  ODE->DisplaySolution( 1, "Lorenz.eps" ); 
  
  return 0;
}
