
// File DemoMarletta.cc

#include "VNODE.h"
#include "Marletta.h"

int main()
{
  VnodeInit();
  
  PtrODENumeric ODE = new Marletta; 
  PtrDataRepr DataRepr = new
    TAYLOR_EXPANSION<MarlettaTaylGenODE,MarlettaTaylGenVAR>;
  
  ODE->LoadProblemParam(1);
  
  PtrVODESolver Solver = new SOLVER_2( ODE, DataRepr );

  cout << "*** Integrating " << ODE->GetName() << endl;
  
  Solver -> Integrate();
				   
  cout << "\n *** Enclosure at T = " << ODE->GetTcur() << endl;
  PrintVec ( ODE->GetTightEncl() );
  
  return 0;
}







