
// FILE DemoTwoBody.cc 

#include "VNODE.h"
#include "TwoBody.h"


int main()
{
  VnodeInit();
  
  PtrODENumeric ODE = new TwoBody; 
  PtrDataRepr DataRepr = new TAYLOR_EXPANSION<TwoBodyTaylGenODE,TwoBodyTaylGenVAR>;
  
  ODE->LoadProblemParam(1);
  
  PtrODESolver Solver = new SOLVER_2( ODE, DataRepr );
  
  Solver->GraphOutput(true);  
  
  cout << "*** Integrating " << ODE->GetName() << endl;
  Solver -> Integrate();
  
  Solver->DisplayStepSize();
  
  for ( int i = 1; i <= ODE->GetSize(); i++ )
    ODE->DisplaySolution(i);
  

  ODE->DisplayPhase(1,2);
  ODE->DisplayPhase(2,3);
  ODE->DisplayPhase(3,1); 
  
  return 0;
}



