
// FILE DetestC3.h 

#ifndef INCLUDED_DetestC3_H
#define INCLUDED_DetestC3_H


#include "odenum.h"  

#define  DetestC3_SIZE 51

template <class Y_TYPE> 
void DetestC3Template( Y_TYPE *yprime, const Y_TYPE *y )
{
  yprime[0] = -2*y[0] + y[1];
  
  for ( int i = 1; i < DetestC3_SIZE-1; i++ )
    {
      yprime[i] = y[i-1] - 2*y[i] + y[i+1];
    }
  
  yprime[DetestC3_SIZE-1] = y[DetestC3_SIZE-2] - 2*y[DetestC3_SIZE-1];

}


// These two lines must be included.

#include "declode.h" 

DECLARE_ODE_PROBLEM(DetestC3,DetestC3_SIZE,DetestC3Template,"Detest C3 Problem");


#endif
