
// FILE Lorenz.cc 

#include "Lorenz.h"


/* A function for setting the problem parameters. Depending on the
   parameter, Param, different sets of parameters can be used. */

void Lorenz :: LoadProblemParam( int Param )
{
  // Set an initial condition.
  INTERVAL_VECTOR Y(3);
  Y(1) = 15.0;
  Y(2) = 15.0;
  Y(3) = 36.0;
  
  SetInitCond(Y);
     
  // Set absolute and relative error tolerances.
  SetAtol(1e-14);
  SetRtol(0);  
  
  if ( Param == 1 )
    {
      // forward integration 
      SetT0( 0 );
      SetTend( 20 );   
    }
  
  if ( Param == 2 )
    {
      // backward integration
      SetT0(0);
      SetTend(-1);
    }
}
