
// FILE ThreeBody.h

#include "ThreeBody.h"


void ThreeBody::LoadProblemParam( int InitCond )
{
  SetAtol(1e-16);
  SetRtol(1e-16);
    
  SetT0( 0 );
  SetTend( 40 );
  
  INTERVAL_VECTOR Y(12);

  if ( InitCond == 1 )
    {
      // x
      Y(1) = 0.0;
      Y(2) = 0.0;
      Y(3) = 0.0;
      
      // y 
      Y(4) = -0.070946548000287;
      Y(5) =  1.075903540029147;
      Y(6) = -1.004956992028862;
      
      // dx
      Y(7) =  1.231870762148251;
      Y(8) = -0.195089035291636;
      Y(9) = -1.036781726856616;
      
      // dy
      Y(10) = 0;
      Y(11) = 0;
      Y(12) = 0;
    }

  if ( InitCond == 2 )
    {
      // x
      Y(1) = 0.0;
      Y(2) = 0.965502;
      Y(3) = -0.965502;
      
      // y 
      Y(4) = 0.0;
      Y(5) = -0.241961;
      Y(6) =  0.241961;
      
      // dx
      Y(7) =  0.933232;
      Y(8) = -0.466616;
      Y(9) = -0.466616;
      
      // dy
      Y(10) =   0.865461;
      Y(11) =  -0.432730;
      Y(12) =  -0.432730;
    }

  SetInitCond(Y);
}


