
// FILE ThreeBody.h

#ifndef INCLUDED_ThreeBody_H
#define INCLUDED_ThreeBody_H


#include "odenum.h"  


#define N_SIZE 3

#define X(i)  Y[i-1]
#define Y(i)  Y[N_SIZE+i-1]
#define VX(i) Y[2*N_SIZE+i-1]
#define VY(i) Y[3*N_SIZE+i-1]

#define XP(i)  Yp[i-1]
#define YP(i)  Yp[N_SIZE+i-1]
#define VXP(i) Yp[2*N_SIZE+i-1]
#define VYP(i) Yp[3*N_SIZE+i-1]


template <class Y_TYPE> 
void ThreeBodyTemplate( Y_TYPE *Yp, const Y_TYPE *Y )
{
  for ( int i = 1; i <= N_SIZE; i++ )
    {
      XP(i) = VX(i);
      YP(i) = VY(i);
      
      VXP(i) = 0.0;
      VYP(i) = 0.0;
      
      for ( int j = 1; j <= N_SIZE; j++ )
	if ( j != i )
	  {
	    Y_TYPE t = sqr( X(j) - X(i) ) + sqr( Y(j) - Y(i) );
	    t *= sqrt(t);
	    
	    VXP(i) += (X(j)-X(i))/t;
	    VYP(i) += (Y(j)-Y(i))/t;
	  }
     }
}




#include "declode.h"
DECLARE_ODE_PROBLEM(ThreeBody,12,ThreeBodyTemplate,"Three-Body Problem");

#undef N_SIZE

#undef X
#undef Y
#undef VX
#undef VY
#undef XP
#undef YP
#undef VXP
#undef VYP

#endif
