
// FILE TwoBody.h

#ifndef INCLUDED_TwoBody_H
#define INCLUDED_TwoBody_H


#include "odenum.h"  

template <class Y_TYPE> 
void TwoBodyTemplate( Y_TYPE *yp, const Y_TYPE *y )
{
  Y_TYPE t = Sqr(y[0]) + Sqr(y[1]);
  t *= Sqrt(t);
  
  yp[0] = y[2];
  yp[1] = y[3];
  yp[2] = -y[0]/t;
  yp[3] = -y[1]/t;
}


#include "declode.h"
DECLARE_ODE_PROBLEM(TwoBody,4,TwoBodyTemplate,"Two-Body Problem");

#endif
