
// FILE constorder.h


#ifndef INCLUDED_CONSTORDER_H
#define INCLUDED_CONSTORDER_H


#include "orderctrl.h"
#include "messgs.h"


/** Constant order control.

   @author Ned Nedialkov
   @date 23 April 2001
   */
class CONST_ORDER : public ORDER_CTRL
{
public:
 
  /** Constructor.
    @param k order
    @pre k > 0
    */
  CONST_ORDER( int k );
  
  /// Returns the order that is set in the constructor.
  int CompOrder( PtrODESolver Solver );

};


inline CONST_ORDER :: CONST_ORDER( int k ) :  
  ORDER_CTRL( k, MSG_CONST_ORDER ) 
{ 
  assert(k>0);
}


inline int CONST_ORDER :: CompOrder( PtrODESolver Solver )
{
  return GetCurOrder(); 
}

#endif 
