
// FILE conststep.h 

   
#ifndef  INCLUDED_CONSTSTEP_H
#define  INCLUDED_CONSTSTEP_H


#include "stepctrl.h"
#include "messgs.h"


/** Constant stepsize control. 
    
    @author Ned Nedialkov 
    @date 21 February 2001
*/
class CONST_STEP : public STEP_CTRL
{
  
public:
  
  /** Constructor. It sets a value for the stepsize.
    
    @param h stepsize 
    @pre h != 0
    */
  CONST_STEP( double h );
  
  /// Returns the stepsize that is set in the constructor. 
  double PredictFirstStep( const PtrODENumeric  ODE, 
			   PtrDataRepr  Data, int order );
  
  /// Returns \c true and the stepsize that is set in the constructor.
  bool PredictStep( double & hPred, double h, 
		    const PtrODENumeric    ODE, 
		    const INTERVAL_VECTOR  & LocErr, 
		    const INTERVAL_VECTOR  & Ytight, 
		    int order );
  
  
  /// Destructor
  ~CONST_STEP(){};
  
  /// Initializes a stepsize control object.
  void Init( const PtrODENumeric  ODE ) { ; };
  
};


inline CONST_STEP :: CONST_STEP( double h ) : STEP_CTRL( MSG_CONST_STEP )
{
  assert( h != 0 );
  SetStepSize( h ) ;
}


inline double CONST_STEP :: PredictFirstStep( const PtrODENumeric  ODE, 
					      PtrDataRepr  Data, int order ) 
{
  return GetStepSize(); 
}


inline bool CONST_STEP :: PredictStep( double & hPred, double h, 
				       const PtrODENumeric  ODE, 
				       const INTERVAL_VECTOR & LocErr, 
				       const INTERVAL_VECTOR & Ytight, 
				       int order )  
{
  hPred = GetStepSize();
  return true; 
}


#endif 
