
// FILE hoinit.h


#ifndef INCLUDED_HOINIT_H
#define INCLUDED_HOINIT_H


#include "taylctrl.h"
#include "initencl.h"
#include "messgs.h"


/** High-order method for validating existence and uniqueness of the
    solution.
    
    This class implements a high-order Taylor series method for
    validating existence and uniqueness of the solution and computing
    a priori bounds on the solution.
  
    @author Ned Nedialkov 
    @date   18 June 2001 */
class HOE : public INIT_ENCL 
{
  
public:
  
  /** Constructor.

      @param max_order maximum order that is allowed. The default values
      is \ref TAYLOR_CTRL::GetMaxOrder(). 
      
      @pre max_order>0 && max_order<=TAYLOR_CTRL::GetMaxOrder()
  */
  HOE( int max_order = TAYLOR_CTRL::GetMaxOrder() );
    
  /** Validates existence and uniqueness of the solution and computes a
    priori bounds on the solution. 
    */
  bool Validate( INTERVAL_VECTOR & Y,
		 INTERVAL_VECTOR & LocErr, 
		 double & h, 
		 int order, 
		 PtrODENumeric ODE,
		 PtrODESolver Solver ); 
  
  /// Initializes an HOE object.
  void Init( PtrODENumeric ODE ); 
  

private:
  
  /// Allocates space
  void ResizeSpace( int N );
  
  /// absolute value of the previous error term
  VECTOR PrevLocErr;
  
  /// work space
  INTERVAL_VECTOR U, P, Y, V;
  
  /// previous stepsize 
  double hPrev;
  
};


inline HOE :: HOE( int max_order )
  : INIT_ENCL( max_order, MSG_HOE_METHOD )
{
  assert( max_order>0 && max_order<=TAYLOR_CTRL::GetMaxOrder() );
}


#endif 
