
// FILE its.cc 

#include "itsbase.h"
#include "taylexp.h"


void ITS_BASE :: 
Prepare( INTERVAL_VECTOR  & LocErr,  
	 const INTERVAL & h, 
	 int order,
	 PtrODENumeric  ODE, 
	 PtrODESolver Solver )
{
  assert( NonZero(h) );
  assert( order>0 && order<=GetMaxOrder() );
  assert( NotNull(ODE) );
  assert( NotNull(Solver) );
  assert( ODE->GetSize()==Dimension(LocErr ) );
  
  assert( NotNull(Solver) );
  
  // Obtain a pointer to the last accepted solution.
  PtrParall Sol = GetSolution<PARALL>( ODE );
  
  if ( Solver->AcceptedStep() )
    {
      PrevSol->SetPointVec( Sol->GetPointVec() );
      PrevSol->SetMatrix  ( Sol->GetMatrix() );
      PrevSol->SetIntervalVec( Sol->GetIntervalVec() );
    }
  else
    {
      Sol->SetPointVec( PrevSol->GetPointVec() );
      Sol->SetMatrix  ( PrevSol->GetMatrix() );
      Sol->SetIntervalVec( PrevSol->GetIntervalVec() );
    }

  
  // Obtain a pointer to the Taylor series generators.
  PtrTaylExp TaylExp = GetDataRepr<TAYL_EXP>( Solver );
  
  const INTERVAL_VECTOR & Yinit = ODE->GetInitEncl();  
  const INTERVAL_VECTOR & Y0    = Sol->GetTightEncl();
  const VECTOR & Ypoint = Sol->GetPointVec();

  assert( Ypoint <= Y0 );  
  assert( Y0 <= Yinit );
  
  if ( !Solver->AcceptedStep() )
    { 
      // Generate the local error term.
      TaylExp->RemTerm->GenerateTerms( Yinit, h, order );
      TaylExp->RemTerm->GetOneTerm( LocErr, order );
    } 
  
  // Compute an enclosure of the approximate point solution.
  TaylExp->PointSol->GenerateTerms( Ypoint, h, order - 1 );
  TaylExp->PointSol->SumTerms( YpointEncl, order - 1 );
  
  // Generate the terms for the variational equation and compute their
  // sum.
  TaylExp->VarSol->GenerateTerms( Y0, h, order-1 );   
  TaylExp->VarSol->SumTerms( Sj, order-1 );   
}



void ITS_BASE :: Init( PtrODENumeric ODE )
{
  assert( NotNull(ODE) );
  ResizeSpace ( ODE->GetSize() ) ;
}


void ITS_BASE :: ResizeSpace ( int N )
{
  assert( N>0 );
  
  Resize( YpointEncl, N );
  Resize( Sj, N, N );  
  
  // Create a solution object
  DELETE( PrevSol );
  PrevSol = new PARALL ( N );
  assert(PrevSol);
}



