
// FILE its.cc 


#include "itsdir.h"


void ITS_DIRECT :: 
Compute( INTERVAL_VECTOR  & Ytight,  
	 INTERVAL_VECTOR  & LocErr,  
	 const INTERVAL & h, 
	 int Order,
	 PtrODENumeric  ODE, 
	 PtrODESolver Solver )
{

  PtrParall Sol = GetSolution<PARALL>( ODE );
  
  const INTERVAL_VECTOR & Yinit = ODE->GetInitEncl();
  const INTERVAL_VECTOR & Y0    = Sol->GetTightEncl();
  
  // Compute a tigh enclosure
  Ytight = YpointEncl + ( Sj*( Y0-Mid(Y0) ) + LocErr );
  
  // The tight and a priori enclosures must intersect.
  int inter = Intersection( Ytight, Yinit, Ytight );
  assert(inter);      
  
  
  // Set the midpoint of Ytight.
  Sol->SetPointVec( Mid(Ytight) );
  
#ifdef DEBUG
  //  if ( ODE->ExactSol() )
  //    CompareSolution( ODE, Ytight, ODE->GetTcur()+h, __FILE__,__LINE__ );
#endif

}






