
// FILE obrtgt.h 


#ifndef INCLUDED_IHOTGT_H
#define INCLUDED_IHOTGT_H


#include "tgtencl.h"
#include "paral.h"


/** Hermite-Obreschkoff method for computing tight bounds on the
    solution.

  The \c IHO class implements the interval Hermite-Obreschkoff method
  for computing tight enclosures on the solution.
  
  @author Ned Nedialkov 
  @date 30 April 2001 */
class IHO : public TIGHT_ENCL 
{
  
public: 
  
  /** Constructor. 
      @param p order of the forward expansion 
      @param q order of the backward expansion
      @pre p>0 && q>0 && p+q+1 <= TAYLOR_CTRL::MaxOrder
  */
  IHO( int p, int q );
  
  /** Computes a tight enclosure. 
   */
  void CompEncl( INTERVAL_VECTOR & Ytight,
		 INTERVAL_VECTOR & LocErr, 
		 const INTERVAL & h, 
		 int order,
		 PtrODENumeric ODE, 
		 PtrODESolver Solver );
  
  /** Initializes an HOE object.   */
  void Init( PtrODENumeric ODE );
  
  /// Destructor
  ~IHO() ;
  
private:
  
  /// allocates space
  void ResizeSpace( int n );
  
  /// stores the coefficients
  void LoadCoeff( int p, int q );  
  
  /// computes the error constant
  INTERVAL CompErrorConst( int p, int q );			   

  
private: 
    
  /// order for the forward step
  int P;

  /// order for the backward step
  int Q;   
  
  /// pointer to the previous solution
  PtrParall PrevSol;  
  
  /// pointers to the coefficients for the method
  INTERVAL *C_pq;
  ///
  INTERVAL *C_qp;  
  
  /// enclosure of the error constant
  INTERVAL  ErrorConst;  
  
  /// predicted point solution
  VECTOR YpointPred;
  
  /// midpoint of a solution
  VECTOR Ymid;
  
  /// work space 
  INTERVAL_VECTOR Z, Yforw, Yback, dj,  Y_1;
  
  /// transformation matrix
  MATRIX  AjBB;
  
  /// transformation matrix
  MATRIX AjCC; 
  
  /// forward matrix from the variational equation
  INTERVAL_MATRIX Sforw;
  
  /// backward matrix from the variational equation
  INTERVAL_MATRIX Sback;
  
  /// enclosure of the inverse of Sback
  INTERVAL_MATRIX SbackInv;
  
  //// work matrix
  INTERVAL_MATRIX Mtmp;

  INTERVAL_MATRIX Bj, Cj;

  /// enclosure of the inverse of AjBB
  INTERVAL_MATRIX AjInv;
};


#endif
