
// FILE odeprobl.cc


#include <typeinfo>

#include "odeprobl.h"
#include "vndinl.h"
#include "vndutils.h"
#include "paral.h"


ODE_PROBLEM :: ODE_PROBLEM( int n, FCN fcn, const string & name ) :
  NAME(name), Size(n), Fcn(fcn), CompSol(NULL)
{
  assert( n>0 && NotNull(fcn) && !name.empty() );
  
  InitCond = new SOLUTION(n);
  assert(&*InitCond);
  
  ProblemInfo.Scalar = ( n == 1? true : false ); 
}


void ODE_PROBLEM :: SetInitCond( const INTERVAL_VECTOR & Y0 )
{
  assert( GetSize() == Dimension(Y0) );
  assert( NotNull(InitCond) ); 
  
  InitCond -> SetTightEncl( Y0 );
  ProblemInfo.PointInitCond = ( MaxNorm(Y0) == 0 ? true : false );
}

