
// FILE solver2.h 

  
#ifndef  INCLUDED_SOLVER2_H
#define  INCLUDED_SOLVER2_H

#include "vodesolv.h"
#include "hoinit.h"
#include "obrtgt.h"
#include "varstep.h"
#include "constorder.h"

/** Solver class. 
  
  This class implements a validated ODE solver with the \c HOE method
  for validating existence and uniqueness of the solution, the \c IHO
  method for computing a tight enclosure of the solution, variable
  stepsize control, and constant order.
  
  @author Ned Nedialkov
  @date   8 June 2001
  */
class SOLVER_2 : public VODE_SOLVER
{
  
public:   
  
  /** Constructor. 
    
    The default value for the order is 17. The IHO method is created
    with \verbatim p = (order-1)/2 \endverbatim and 
    \verbatim q = order/2, \endverbatim while the HOE method is created with
    order \c order. 

    Here, \c / gives the integer part of the quotients \c (order-1)/2 and \c order/2.
      
    @param ODE pointer to a problem
    @param Data pointer to a data representation object
    @param order order of the method; the default value is 17
    
    @pre NotNull(ODE) && pre NotNull(Data) && order>0 && order <= order <= TAYLOR_CTRL::MaxOrder */
  SOLVER_2( const PtrODENumeric ODE, const PtrDataRepr Data, 
	    int order = 17 );
  
};


inline SOLVER_2 :: SOLVER_2( const PtrODENumeric ODE, 
			     const PtrDataRepr Data, 
			     int order ) 
  :
  VODE_SOLVER( ODE, Data, 
	       new CONST_ORDER( order ),
	       new VAR_STEP_CTRL,
	       new HOE,   
	       new IHO( (order-1)/2, (order)/2 ) )
    
    {
    }
  

#endif
