
// FILE sortcols.cc

#include "tgtencl.h"
#include "vndutils.h"

struct LengthStruct
{ 
  double len;
  INT  pos;
}; 

int Compare( const void *a1, const void *b1 )
{
  LengthStruct *a =  (LengthStruct *)a1; 
  LengthStruct *b =  (LengthStruct *)b1; 
  
  if  ( a->len > b->len ) 
    return -1;
  if (a->len < b->len) 
    return 1;   
  
  return 0;
}


void TIGHT_ENCL :: RearrangeColumns ( MATRIX & B, const MATRIX & A, 
					     const INTERVAL_VECTOR & R )
{
  int N = Dimension(R);
  assert(N>0);
  
  LengthStruct * Len = new LengthStruct [N];
  
  BiasRoundNear();
  for ( int j = 1; j <= N; j++ )
    {
      Len[j-1].pos = j;
      Len[j-1].len = LengthColumn(A, j)*Diam(R(j));
    }
  
#ifdef DEBUG
  MATRIX L(1,N);
  for ( int j = 1; j <= N; j++ )
    L(1,j) = Len[j-1].len;
#endif  

  bool sort = false;
  for ( int i = 0; i < N-1; i++ )
    {
      if ( Len[i].len < Len[i+1].len)
	{
	  sort = true;
	  break;
	}
    }

  if ( sort ) 
    {
      qsort( (void *)Len, N, sizeof(LengthStruct), Compare );

      for (int  j = 1; j <= N; j++ )
	CopyColumn(B, j, A, Len[j-1].pos );	
      
#ifdef DEBUG
      for ( int i = 0; i < N-1; i++ )
	assert(Len[i].len >= Len[i+1].len);
      
      MATRIX P(N,N);
	  
      Clear(P);
      for (int  j = 1; j <= N; j++ )
	P(Len[j-1].pos,j) = 1;
        
      L = L*P;
      for ( int j = 1; j <= N-1; j++ )
	assert( L(1,j)>=L(1,j+1) );
      
      assert( MaxNorm(B-A*P)==0 );
#endif  
    }
  else
    B = A;

  delete [] Len;
}
