
// FILE stepctrl.cc 


#include "stepctrl.h"

double STEP_CTRL :: IfLastStep( double t, double h, double Tend )
{
  assert(t!=Tend);
  
  if ( t < Tend )
    {
      if ( t+h < Tend && t + 2*h > Tend )
	h = (Tend-t)/2.0;
    }
  else
    {
      //      h = -h;
      if ( t+h > Tend && t + 2*h < Tend )
	h = (Tend - t)/2.0;
    }
  
  return h;
}

double  STEP_CTRL :: CompMinStepSize( double t, double Tend )
{
  assert(t!=Tend);
  
  double MinStep;
  
  BiasRoundUp();
  if ( t < Tend )
    {
      MinStep =  Succ(t) - t;
      t = Tend - t;
      assert(Diam(t+Hull(0,MinStep))>0);
    }
  else
    {
      MinStep = t - Pred(t);
      t = t - Tend;
      assert(Diam(t-Hull(0,MinStep))>0);
    }
  
  assert(min(10*MinStep, t)>0);
  return min(10*MinStep, t);
}


double STEP_CTRL :: CompNextPoint( double h, double t, double Tend )
{
  assert(h!=0);
  double Tn;

  if ( Tend > t ) // forward integration
    {
      // The next point is the minumum of the rounded down result of t+h
      // and Tend.
      BiasRoundDown();
      Tn = min(t+fabs(h),Tend);
    }
  else 
    {
      // The next point is the maximum of the rounded up result of t+h
      // and Tend.
      BiasRoundUp();
      Tn = max(t+h,Tend);
    }
  return Tn;
}



