
// FILE ttaylode.cc

#include "vndinl.h"
#include "ttaylode.h"


TAYLOR_ODE_TAD :: TAYLOR_ODE_TAD( int n, TAD ptadiff ) 
  : TAYLOR_ODE(n)
{
  // initialize the Taylor series generator for the solution of the ODE
  assert(n>0);
  assert(NotNull(ptadiff));
  
  extern int  maxlength_INTERVAL;  
  maxlength_INTERVAL = GetMaxOrder();  
  
  Tin   = new TINTERVAL [2*n];
  assert(Tin);
  Tout  = Tin + n;
  
  GenTaylorODE = ptadiff;
}


void TAYLOR_ODE_TAD :: 
GenerateTerms( const INTERVAL_VECTOR & Y, const INTERVAL & H, int Order ) 
{ 
  assert( Order>0 && Order <= GetMaxOrder() && 
	  Dimension(Y) == GetDim() &&
	  NonZero(H) 
	  );
  
  int N = GetDim();
  
  SetH( H );
  SetOrder( Order );

  GenTaylorODE( Tout, Tin );

  int row;
  
  // reset the previously created terms
  for( row = 0; row < N; row++ ) 
    Tout[row].reset(); 
  
  // specify the point of expansion
  for( row = 0; row < N; row++ ) 
    Tin[row][0] = Y(row+1);
  
  // generate the terms
  int tmp = 0;
  for( int k = 0; k < Order; k++ )
    {
      tmp++;
      for ( row = 0; row < N; row++ )
	{
	  // compute the terms for the Taylor expansion of the right side
	  Tout[row].eval(k);
	  
	  // compute the terms for the Taylor expansion of the solution
      	  Tin[row][tmp] = H*Tout[row][k] / double(tmp);
	}
    }
}


void TAYLOR_ODE_TAD 
:: SumTerms( INTERVAL_VECTOR & Sum, int Order )
{
  assert( Dimension(Sum) == GetDim() &&
	  Order > 0 && Order <= GetOrder() );
  
  int N = GetDim();
  
  INTERVAL Tmp;
  for ( int row = 0; row < N; row++)
    {
      Tmp = 0;
      for ( int k = Order; k >= 0; k-- )
	Tmp += Tin[row][k];

      Sum(row+1) = Tmp;  
    }
}


void TAYLOR_ODE_TAD :: 
GetOneTerm( INTERVAL_VECTOR & Yk, int Order )
{
  assert( Order>=0 && Order<=GetOrder());
  assert( Dimension(Yk)==GetDim() );
  
  int N = GetDim();
  
  for ( int row = 0; row < N; row++) 
    Yk(row+1) = Tin[row][Order]; 
}



TAYLOR_ODE_TAD ::  ~TAYLOR_ODE_TAD()
{ 
  delete [] Tin; 
} 

