
// FILE ttaylode.h


#ifndef INCLUDED_TTAYLODE_H
#define INCLUDED_TTAYLODE_H


#include "taylode.h"
#include "TINTERVAL.h"


/// Pointer to a function for storing the computational graph. 
typedef void (*TAD)( TINTERVAL *yp, const TINTERVAL *y );


/** Taylor coefficient generator. 

  This class uses the \c TADIFF package to generate Taylor
  coefficients for the solution to 
  \f$ y^\prime = f(y) \f$, 
  \f$ y(t_{j}) \in [y_{j}] \f$. 
  
  @author Ned Nedialkov 
  @date   8 June 2001 
  */
class TAYLOR_ODE_TAD : public TAYLOR_ODE
{

public:
  
  /** Constructor.

    @param n number of equations 
    @param ptadiff pointer to a function for storing the computational graph
      
    @pre n > 0 && NotNull(ptadiff)
    */
  TAYLOR_ODE_TAD( int n, TAD ptadiff );

  /** Generates Taylor series terms.       
   */
  void GenerateTerms( const INTERVAL_VECTOR & Y , 
		      const INTERVAL & h, int k ); 
  
  /** Sums Taylor series terms. 
  */
  void SumTerms( INTERVAL_VECTOR & Sum, int k );
  
  /** Obtains the \c k-th Taylor series term.
   */
  void GetOneTerm( INTERVAL_VECTOR & Yk, int k );
  
  /// Destructor
  ~TAYLOR_ODE_TAD();
  
  
private:
  
  /// work space
  TINTERVAL  *Tin,  *Tout; 
  
  /// pointer to a function for storing the computational graph.
  TAD GenTaylorODE;
  
};


#endif 
