
// FILE varstep.h 



#ifndef INCLUDED_EIJSTEP_H
#define INCLUDED_EIJSTEP_H

#include "stepctrl.h"


/** Variable stepsize control. 

  This class implements a variable stepsize control.
    
    @author Ned Nedialkov
    @date   8 June 2001
    
*/
class VAR_STEP_CTRL : public STEP_CTRL
{
  
public:
  
  /** Predicts an initial stepsize.
   */
  double PredictFirstStep( const PtrODENumeric , PtrDataRepr , int );
  
  /** Predicts a new stepsize.
   */
  bool  PredictStep( double  & hPred, double h, 
		     const PtrODENumeric  ODE, 
		     const INTERVAL_VECTOR & LocErr, 
		     const INTERVAL_VECTOR & Ytight, 
		     int order );
  
  /// Initializes the method.
  void Init( const PtrODENumeric  ODE );
  
  /// Destructor
  ~VAR_STEP_CTRL() {}
  
private:
  
  /// work space
  INTERVAL_VECTOR Tmp;
  
};


inline void VAR_STEP_CTRL :: Init( const PtrODENumeric  ODE ) 
{
  Resize(Tmp, ODE->GetSize());
}


#endif 




