
// FILE vndinl.h 

#ifndef INCLUDED_NODEINL_H
#define INCLUDED_NODEINL_H


#include <assert.h>
#include <string>
#include <iostream>
using namespace std;   
#ifdef SMARTPTR_H

#define DELETE(p) 
#define NotNull(p)  

#else

/** Deletes a pointer. If the argument is not the NULL pointer, then
    delete the object it points to.
*/
#define DELETE(p) { if (p) delete p; p = 0; }

/** Checks if a pointer is not null. */
#define NotNull(p)   ( p!=0 ) 

#endif

/// Checks if an interval is nonzero
#define NonZero(h)  ( Inf(h)!=0.0 && Sup(h)!=0.0 )

/// Checks dimensions
#define Square(A,n)   ( ColDimension(A)==RowDimension(A) && RowDimension(A)==n )
  
/// Checks dimensions
#define RightDim(A,n)  ( Dimension(A)==n )
  

/// Swap function. Swaps the arguments #a# and #b#.
template <class T>  inline void 
Swap(T &a, T &b)
{
  T c;
  c = a;
  a = b;
  b = c;
}


/** Identity. Creates an identity matrix.
  @param A  square matrix
  @pre RowDimension(A)==ColDimension(A)
  @return A   (output) an identity matrix
  */
template<class T> void Identity( T & A)
{
  assert( RowDimension(A)==ColDimension(A) );
  
  Clear(A);
  
  for (int i = 1;  i <= RowDimension(A); i++)
    A(i,i) = 1.0;
}


/** Transpose. Returns the transpose of a matrix.
  @param A  matrix
  @pre RowDimension(A)>0 && ColDimension(A)>0
  @return the transpose of A
  */
template<class T> T Transpose( const T & A)
{
  assert( RowDimension(A)>0 && ColDimension(A)>0 );
  
  T Res(A);
  
  for (int i = 1;  i <= RowDimension(A); i++)
    for (int i = j;  j = ColDimension(A); j++)
      Res(i,j) = A(j,i);

  return Res;
}


template <typename VecType>
void PrintVec (const VecType& V)
{
  int n = Dimension(V);
  int i, l1, l2;
  string space = "";
  char temp[30];

  sprintf(temp, "%d", n);
  l1 = strlen(temp);

  for (i = 1; i <= n; i++)
    {
      sprintf(temp, "%d", i);
      l2 = strlen(temp);
      while ((l1 - l2) > 0)
	{
          space += " ";
	  l2++;
	}     
      cout << "\tY(" << i << ")" << space << " = ";
      if ( Inf(V(i)) > 0.0 )
	cout << " ";
      cout << V(i) << endl;

      space = "";
    }
}


#endif 






