
// FILE vndout.cc 

#include <assert.h>
#include <stdio.h>
#include <math.h>
#include "plot.h"      

extern char *OutputString;
extern FILE * f_solution, *f_apriori;
static FILE *f_stepsize, *f_order;


void DeleteOutput( FILE *f, double t )
{
  static char delete_buf[40];
  
  sprintf(delete_buf, OutputString, t,  t);
  for ( unsigned int i = 0; i < strlen(delete_buf); i++)
    fputc( 8, f );
}


void OpenFiles( const char *mode )
{
  /* Open files for writing data. These files will be used by GNUplot
     to plot the solutions. */
  f_solution = fopen(SOLUTION_DATA_FILE, mode); 
      
  assert(f_solution!=NULL); 
  
  f_apriori = fopen(APRIORI_DATA_FILE, mode); 
  assert(f_apriori!=NULL);
  
  f_stepsize = fopen(STEPSIZE_DATA_FILE, mode); 
  assert(f_stepsize!=NULL);
  
  f_order = fopen(ORDER_DATA_FILE, mode); 
  assert(f_order!=NULL);
}


void WriteData( int Order, double t, double h_old, int AcceptedSteps,
		const INTERVAL_VECTOR & Yinit, 
		const INTERVAL_VECTOR & Ytight,
		bool Forward = true )
{
  assert(f_stepsize);
  assert(f_order);
  assert(f_apriori);
  assert(f_solution);
  
  WriteStepSize(f_stepsize,  t, fabs(h_old));
  WriteOrder   (f_order,     AcceptedSteps, Order );
  WriteSolution(f_apriori  , t -h_old,   &Yinit );
  WriteSolution(f_solution , t   ,   &Ytight );
} 


void CloseFiles()
{
  fclose (f_solution);
  fclose (f_apriori);
  fclose (f_stepsize);
  fclose (f_order);
}





