
// File vndutils.h 

#include "vnderror.h"
#include "vnodecnf.h"
#include "vndutils.h"
#include "vndinl.h"
#include "vndstat.h"


template <class T>  
double MaxNormVec( const T & V )
{
  int  Dim = Dimension(V);  
  assert( Dim > 0 );
  
  double Max = 0;
  
  for ( int i = 1; i <= Dim; i++ )
    if ( Abs( V(i) ) > Max )
      Max = Abs(V(i));
  
  return Max;
}



double MaxNorm( const VECTOR & A )
{
  return MaxNormVec(A);
}

double MaxNorm( const INTERVAL_VECTOR & A )
{
  return MaxNormVec(A);
}



template <class T>  
double MaxNormMat( const T & A )
{
  int Arows = RowDimension(A);
  int Acols = ColDimension(A);
  
  assert( Arows>0 && Acols > 0 );
  
  double Max = 0;
  INTERVAL Sum;

  for ( int i = 1; i <= Arows; i++ )
    {
      Sum = 0.0;
      for ( int j = 1; j <= Acols; j++ )
	Sum += Abs(A(i,j));
      
      if ( Sup(Sum)  > Max )
	Max = Sup(Sum);
    }

  return Max;
}


double  MaxNorm( const MATRIX & A )
{
  return MaxNormMat(A);
}

double  MaxNorm( const INTERVAL_MATRIX & A )
{
  return MaxNormMat(A);
}


double LengthColumn( const MATRIX & M, int j )
{
  assert( ColDimension(M)>0 && RowDimension(M)>0 && 
	  j>=1 && j<=ColDimension(M) );
  
  return Norm( Col(M,j) );
}


void CopyColumn( MATRIX & A, int j, const MATRIX & B, int i )
{
  assert( ColDimension(A)==ColDimension(B) && 
	  RowDimension(A)==RowDimension(B) && 
	  ColDimension(A)>0 && RowDimension(A)>0 && 
	  j>=1 && j<=ColDimension(A)  && 
	  i>=1 && i<=ColDimension(B) );
  
  for ( int k = 1; k <= RowDimension(A); k++ )
    A(k,j) = B(k,i);
}










  

