
// FILE vndutils.h


#ifndef INCLUDED_VNDUTIL_H
#define INCLUDED_VNDUTIL_H

#include "vnodecnf.h"


/** Computes the max norm of an interval vector.

  @param V an interval vector
  @return the max norm of V
  @pre Dimension(V)>0
  */
extern double MaxNorm ( const INTERVAL_VECTOR & V ); 


/** Computes the max norm of a point vector.
  @param V a point vector
  @return the max norm of V
  @pre Dimension(V)>0
  */
extern double MaxNorm ( const VECTOR & V );


/** Computes the max norm of an interval matrix.
  @param M an interval matrix
  @return the max norm of M
  @pre ColDimension(M)>0 && RowDimension(M)>0
  */
extern double MaxNorm ( const INTERVAL_MATRIX & M );


/** Computes the max norm of a point matrix.
  @param M a point matrix
  @return the max norm of M
  @pre ColDimension(M)>0 && RowDimension(M)>0
  */
extern double MaxNorm ( const MATRIX & );


/** Compute the Euclidean norm of a column of a point matrix.

  @param M point matrix
  @param j j-th  column in M
  @pre  ColDimension(M)>0 && RowDimension(M)>0 &&
  @pre  j>=1 && j <= ColDimension(M)
  @return the Euclidean norm of the j-th column of M
  */
extern double LengthColumn( const MATRIX & M, int j );

/** Copy the j-th column of B to the i-th column of A.  
  @param A point matrix 
  @param B point matrix 
  @param i column number in A, where the j-th column of B is to be copied 
  @param j column of B that has to be copied to the i-th column of A 

  @return B - (output)
  @pre   ColDimension(A)==ColDimension(B) && 
  @pre   RowDimension(A)==RowDimension(B) && 
  @pre	  ColDimension(A)>0 && RowDimension(A)>0 && 
  @pre	  j>=1 && j<=ColDimension(A)  && 
  @pre	  i>=1 && i<=ColDimension(B) );
  
*/ 
extern void CopyColumn (MATRIX & A, int i, const MATRIX & B, int j);


#endif

