
// FILE TestTwoBody.cc

/*
  Copyright (C) 2000 Nedialko S. Nedialkov
  
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or (at
your option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program - see the file COPYRIGHT; if not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
MA 02111-1307, USA.

 Nedialko S. Nedialkov
 Department of Computing and Software
 McMaster University
 Hamilton, Ontario, CANADA
 E-mail: nedialk@mcmaster.ca

*/



#include "VNODE.h"    
#include "TwoBody.h"  


int main()
{
  
  VnodeInit();

  PtrODENumeric ODE = new TwoBody; 
  PtrDataRepr DataRepr = new
    TAYLOR_EXPANSION<TwoBodyTaylGenODE,TwoBodyTaylGenVAR>;
  
  ODE->LoadProblemParam( 1 );
   
  PtrODESolver Solver_1 = new SOLVER_1( ODE, DataRepr );
  PtrODESolver Solver_2 = new SOLVER_2( ODE, DataRepr );
  
  Solver_1->VerboseOutput(true); 
  cout << "\n*** Integrating " << ODE->GetName() << endl;
  Solver_1 -> Integrate();

  INTERVAL_VECTOR Y1( ODE->GetTightEncl() );

  Solver_2->VerboseOutput(true); 
  cout << "\n*** Integrating " << ODE->GetName() << endl;
  Solver_2 -> Integrate();

  INTERVAL_VECTOR Y2( ODE->GetTightEncl() );

  if ( !Intersection(Y1,Y2,Y1) )
    VnodeError( "VNODE error in TestTwoBody.cc" );

  return 0;
}



