function testinfo(fid,info)
% testinfo(fid,info)
% 
% deal with the test data and save it in the output file
%
% Input
%   fid    the input file
%   info   the test data
%
global ALGS
%
fprintf(fid,'\n\n--------------------------------------------------------------------');
fprintf(fid,'\nMatrix size: %d', info(2).matSize);
fprintf(fid,'\nBlock size:  %d', info(2).blkSize); 
%
% Test report
fprintf(fid,'\n\nError In Orthogonality:\n');
for i = 1:ALGS
    fprintf(fid,info(i).tag);
    fprintf(fid,' %1.2E\n',info(i).orthErr);
end
%
fprintf(fid,'\nError In Tridiagonalization:\n');
for i = 1:ALGS
    fprintf(fid,info(i).tag);
    fprintf(fid,' %1.2E\n',info(i).err);
end
%
fprintf(fid,'\nTotal Of Orthogonalization Computation:\n');
for i = 1:ALGS
    fprintf(fid,info(i).tag);
    fprintf(fid,' %d\n',info(i).triVec + info(i).blkSize*info(i).blkTriVec);
end
%
fprintf(fid,'\nTime For Block Tridiagonalization:\n');
max = 0.0;
maxIdx = 0;
for i = 2:ALGS
    if (info(i).blkTriTime > max)
        max = info(i).blkTriTime;
        maxIdx = i;
    end
end
for i = 2:ALGS
    fprintf(fid,info(i).tag);
    fprintf(fid,' %6.2f  %6.2f%%\n',info(i).blkTriTime,info(i).blkTriTime/max*100);
end
%
fprintf(fid,'\nTime For Tridiagonalization:\n');
max = 0.0;
maxIdx = 0;
for i = 2:ALGS
    if (info(i).triTime > max)
        max = info(i).triTime;
        maxIdx = i;
    end
end
for i = 2:ALGS
    fprintf(fid,info(i).tag);
    fprintf(fid,' %6.2f  %6.2f%%\n',info(i).triTime,info(i).triTime/max*100);
end
%
fprintf(fid,'\nTotal Of Time:\n');
max = 0.0;
maxIdx = 0;
for i = 1:ALGS
    if (info(i).blkTriTime + info(i).triTime > max)
        max = info(i).blkTriTime + info(i).triTime;
        maxIdx = i;
    end
end
for i = 1:ALGS
    fprintf(fid,info(i).tag);
    fprintf(fid,' %6.2f  %6.2f%%\n',info(i).blkTriTime + info(i).triTime, ...
        (info(i).blkTriTime + info(i).triTime)/max*100);
end
