/****************************************************************************
 *
 * blklan.c
 *
 * Abstract 
 *   Define the prototypes of all routines implemented for block
 *   Lanczos algorithm.
 *
 * Student:  Guohong Liu
 *
 * ID:       0385117
 *
 ****************************************************************************/

#ifndef __BLKLAN_H
#define __BLKLAN_H

#include "computing.h"

/****************************************************************************
 *
 * Data structure
 *
 ****************************************************************************/

#define Boolean int
#define SUCCEED	1
#define FAIL	0
#define TRUE	1
#define FALSE	0	

#ifdef MATLAB_COMP
typedef struct dataFile {
    int n;
    int bs;
    DoubleComplex *A;
    DoubleComplex *S;
    DoubleComplex *RandMat;
    DoubleComplex *randVec; 
}DataFile;

DataFile readDataFile (char *file);
#endif

/****************************************************************************
 *
 * Prototypes of functions
 *
 ****************************************************************************/

Boolean isParamValid (int n, int bs, int *info);

int blkTriInit (int na, DoubleComplex *A_p, int blk, DoubleComplex *S_p, 
                DoubleComplex *a_p, DoubleReal *b_p, 
                DoubleComplex *Q_p, DoubleComplex *P_p);
void blkTri ();
void blkTriEnd ();
void blkTriExcept ();
void blkTriInfo (int iter);

void detectW (int iter);
void orthInterval (int iter);
void completeW (int iter);
void orthR (int iter);

int lanTriInit ();
int lanTri ();
void lanTriEnd ();
void lanTriExcept ();
void lanTriInfo (int iter);

void detectw (int iter);
void orthr (int iter);
void sbmvmul (int iter);

void zeros (DoubleComplex *array, int n);
void ones (DoubleComplex *array, int n);
void setRealArray (DoubleReal *array, int n, DoubleReal val);
void showComplexMat (DoubleComplexMat *A, char *tag);
void showComplexVec (DoubleComplexVec *a, char *tag);
void showRealVec (DoubleRealVec *a, char *tag);

int triErrChk (int n, DoubleComplex *A_m, DoubleComplex *a_m, 
               DoubleReal *b_m, DoubleComplex *Q_m, DoubleComplex *P_m); 
int orthErr (DoubleComplexMat *A, double *err);

#endif

