#include <sys/types.h> 
#include <stdio.h> 
#include <unistd.h>

int main() {
	pid_t pid;
	/* fork a child process */
	pid = fork();
	if (pid < 0) { /* error occurred */
		fprintf(stderr, "Fork Failed");
		return 1;
	} else if (pid == 0) { /* child process */
		sleep(10);
		printf("Child terminating\n");
	} else { /* parent process */
		/* parent will wait for the child to complete */
		printf("Press enter to continue in parent\n");
		getchar();
	}
	return 0;
}
