package com.CAS765.android.networktester;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteOrder;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.text.method.ScrollingMovementMethod;
import android.view.Menu;
import android.view.View;
import android.widget.Button;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;

public class MainActivity extends Activity {

	private Button mPingButton;
	private Button mFileDownloadButton;
	private Button mNetworkCfgInfoButton;
	private ProgressBar mProgressBar;
	private TextView mText;
	private WifiReceiver mReceiverWifi;
	
	final String pingCmd = "ping -c 5 www.google.com";
	final String testURL = "http://www.cas.mcmaster.ca/~rzheng/course/COSC7388fa12/COSC7388_tutorial.pptx";

	// @TargetApi(9) //Target API level >= 9
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);

		mPingButton = (Button) findViewById(R.id.ping_button);
		mFileDownloadButton = (Button) findViewById(R.id.fd_button);
		mNetworkCfgInfoButton = (Button) findViewById(R.id.netinfo_button);
		mText = (TextView) findViewById(R.id.text_display);
		mText.setMovementMethod(new ScrollingMovementMethod());

		mPingButton.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				// Network needs to be handled in a separate thread
				mText.setText("");
				new PingTask().execute();
			}
		});

		mNetworkCfgInfoButton.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				// Network needs to be handled in a separate thread
				mText.setText("");
				new networkConnectivityTask().execute();
			}
		});

		mFileDownloadButton.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				// Network needs to be handled in a separate thread
				mText.setText("");
				final fileDownloadTask downloader = new fileDownloadTask();
				downloader.execute();

				//Cancel the download if lasts more than 60 second
				Handler handler = new Handler();
				handler.postDelayed(new Runnable() {
					@Override
					public void run() {
						if (downloader.getStatus() == AsyncTask.Status.RUNNING) {
							downloader.cancel(true);
							mText.setText("Download stalled and cancelled");
						}
					}
				}, 60000);
			}
		});

		mProgressBar = (ProgressBar) findViewById(R.id.test_progressBar);
		
		if (mReceiverWifi == null)
			mReceiverWifi = new WifiReceiver();
		
		registerReceiver(mReceiverWifi, new IntentFilter(
				WifiManager.NETWORK_STATE_CHANGED_ACTION));
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.main, menu);
		return true;
	}

	private class PingTask extends AsyncTask<Void, Void, String> {
		@Override
		protected String doInBackground(Void... params) {
			String result = null;

			try {
				String pingLine;
				BufferedReader bufferedReader = new BufferedReader(
						new InputStreamReader(Runtime.getRuntime()
								.exec(pingCmd).getInputStream()));
				while ((pingLine = bufferedReader.readLine()) != null) {
					// hard coded
					if (pingLine.startsWith("rtt min"))
						result = pingLine;
				}
			} catch (IOException e) {
				result = new String("Command error");
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			return result;
		}

		@Override
		protected void onPostExecute(String result) {
			if (result != null)
				mText.setText(result);
			else
				Toast.makeText(MainActivity.this, "Opps...", Toast.LENGTH_SHORT)
						.show();
		}
	}

	// this is for WiFi only
	private class networkConnectivityTask extends
			AsyncTask<Void, Void, WifiInfo> {

		@Override
		protected WifiInfo doInBackground(Void... params) {
			WifiInfo info = null;
			try {
				ConnectivityManager cm = (ConnectivityManager) getSystemService(Context.CONNECTIVITY_SERVICE);
				NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
				if (activeNetwork.getType() == ConnectivityManager.TYPE_WIFI) {
					// this is WiFi
					WifiManager wifiManger = (WifiManager) getSystemService(Context.WIFI_SERVICE);
					info = wifiManger.getConnectionInfo();
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
			return info;
		}

		@Override
		protected void onPostExecute(WifiInfo info) {
			if (info != null) {
				mText.append("SSID: " + info.getSSID() + "\n");
				mText.append("BSSID: " + info.getBSSID() + "\n");
				mText.append("IP address: "
						+ ipToDottedDecimal(info.getIpAddress()) + "\n");
				mText.append("MAC address: " + info.getMacAddress() + "\n");
				mText.append("Link speed: " + info.getLinkSpeed() + "Mbps\n");
				mText.append("RSSI: " + info.getRssi() + "dBm\n");
			}
		}

	}

	private class fileDownloadTask extends AsyncTask<Void, Integer, String> {

		private int totalBytes;
		HttpURLConnection connection;
		@Override
		protected String doInBackground(Void... params) {
			String result = null;
			int numByte = 0;
			long timeElaspeConnect, timeElaspeDownload;

			try {
				long currentTime = System.currentTimeMillis();
				URL url = new URL(testURL);
				connection = (HttpURLConnection) url
						.openConnection();

				try {
					InputStream in = connection.getInputStream();

					if (connection.getResponseCode() != HttpURLConnection.HTTP_OK) {
						return null;
					}
					
					totalBytes = connection.getContentLength();

					timeElaspeConnect = System.currentTimeMillis()
							- currentTime;
					currentTime = System.currentTimeMillis();

					int bytesRead = 0;
					byte[] buffer = new byte[1024];
					while ((bytesRead = in.read(buffer)) > 0) {
						numByte += bytesRead;
						publishProgress(numByte);
					}
					timeElaspeDownload = System.currentTimeMillis()
							- currentTime;
					result = "Connection time: " + timeElaspeConnect / 1000.0
							+ "(s) \n" + "Downloading time for " + numByte
							+ " byte : " + timeElaspeDownload / 1000 + "(s) \n" + "Avg. data rate: " + numByte/timeElaspeDownload + "(KBps)";
				} finally {
					connection.disconnect();
				}

			} catch (Exception e) {
				e.printStackTrace();
			}
			return result;
		}

		 @Override
		    protected void onPreExecute() {
		        mProgressBar.setVisibility(View.VISIBLE);
		        mProgressBar.setProgress(0);
		    }
		 
		@Override
		protected void onPostExecute(String result) {
	        mProgressBar.setVisibility(View.INVISIBLE);
			if (result != null) {
				mText.setText(result);
			}
		}
		
		@Override
		  protected void onProgressUpdate(Integer... values) {
			mProgressBar.setProgress(mProgressBar.getMax()*values[0]/totalBytes);
		}

		@Override
		protected void onCancelled(String result) {
			if (connection != null)
				connection.disconnect();
	        mProgressBar.setVisibility(View.INVISIBLE);
			mText.setText("Downloading stalled and cancelled");
		}

	}

	// A helper class to convert IP address in INT32 to dotted decimal
	// representation
	// Check byte order first
	// IPv4Address in 32bits
	public static String ipToDottedDecimal(int ipAddress) {
		int a = (ipAddress >> 0) & 0xFF, b = (ipAddress >> 8) & 0xFF, c = (ipAddress >> 16) & 0xFF, d = (ipAddress >> 24) & 0xFF;
		if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN)
			return Integer.toString(a) + "." + Integer.toString(b) + "."
					+ Integer.toString(c) + "." + Integer.toString(d);
		else
			return Integer.toString(d) + "." + Integer.toString(c) + "."
					+ Integer.toString(b) + "." + Integer.toString(a);
	}
	
	//Display information from network state changes
	private class WifiReceiver extends BroadcastReceiver {
		public void onReceive(Context c, Intent intent) {
			NetworkInfo info = (NetworkInfo)intent.getExtras().getParcelable("networkInfo");
			mText.setText(info.getDetailedState().toString());
		};
	}
}
